/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;

public class OperatorDoOnEach<T>
implements Observable.Operator<T, T> {
    private final Observer<? super T> doOnEachObserver;

    public OperatorDoOnEach(Observer<? super T> doOnEachObserver) {
        this.doOnEachObserver = doOnEachObserver;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> observer) {
        return new Subscriber<T>(observer){

            @Override
            public void onCompleted() {
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onCompleted();
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onError(e);
                }
                catch (Throwable e2) {
                    observer.onError(e2);
                    return;
                }
                observer.onError(e);
            }

            @Override
            public void onNext(T value) {
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onNext(value);
                }
                catch (Throwable e) {
                    this.onError(OnErrorThrowable.addValueAsLastCause(e, value));
                    return;
                }
                observer.onNext(value);
            }
        };
    }
}

