/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;
import rx.subscriptions.CompositeSubscription;

public class OperatorGroupByUntil<T, K, R, D>
implements Observable.Operator<GroupedObservable<K, R>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends R> valueSelector;
    final Func1<? super GroupedObservable<K, R>, ? extends Observable<? extends D>> durationSelector;

    public OperatorGroupByUntil(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> valueSelector, Func1<? super GroupedObservable<K, R>, ? extends Observable<? extends D>> durationSelector) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.durationSelector = durationSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, R>> child) {
        final SerializedSubscriber<? super GroupedObservable<K, R>> s = new SerializedSubscriber<GroupedObservable<K, R>>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        return new Subscriber<T>(child){
            final Object guard;
            Map<K, GroupSubject<K, R>> groups;
            final Subscriber<T> self;
            {
                super(x0);
                this.guard = new Object();
                this.groups = new HashMap();
                this.self = this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T t) {
                GroupSubject gs;
                Object value;
                Object key;
                try {
                    key = OperatorGroupByUntil.this.keySelector.call(t);
                    value = OperatorGroupByUntil.this.valueSelector.call(t);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                boolean newGroup = false;
                Object object = this.guard;
                synchronized (object) {
                    if (this.groups == null) {
                        return;
                    }
                    gs = this.groups.get(key);
                    if (gs == null) {
                        gs = GroupSubject.create(key);
                        this.groups.put(key, gs);
                        newGroup = true;
                    }
                }
                if (newGroup) {
                    Observable durationObs;
                    GroupedObservable groupObs = gs.toObservable();
                    try {
                        durationObs = OperatorGroupByUntil.this.durationSelector.call(groupObs);
                    }
                    catch (Throwable e) {
                        this.onError(e);
                        return;
                    }
                    s.onNext(groupObs);
                    final Object fKey = key;
                    Subscriber durationSub = new Subscriber<D>(){
                        boolean once = true;

                        @Override
                        public void onNext(D t) {
                            this.onCompleted();
                        }

                        @Override
                        public void onError(Throwable e) {
                            self.onError(e);
                        }

                        @Override
                        public void onCompleted() {
                            if (this.once) {
                                this.once = false;
                                this.expire(fKey, this);
                            }
                        }
                    };
                    csub.add(durationSub);
                    durationObs.unsafeSubscribe(durationSub);
                }
                gs.onNext(value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void expire(K key, Subscription subscription) {
                GroupSubject g;
                Object object = this.guard;
                synchronized (object) {
                    if (this.groups == null) {
                        return;
                    }
                    g = this.groups.remove(key);
                }
                if (g != null) {
                    g.onCompleted();
                }
                csub.remove(subscription);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                ArrayList localGroups;
                Object object = this.guard;
                synchronized (object) {
                    if (this.groups == null) {
                        return;
                    }
                    localGroups = new ArrayList(this.groups.values());
                    this.groups = null;
                }
                for (GroupSubject groupSubject : localGroups) {
                    groupSubject.onError(e);
                }
                s.onError(e);
                this.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                ArrayList localGroups;
                Object object = this.guard;
                synchronized (object) {
                    if (this.groups == null) {
                        return;
                    }
                    localGroups = new ArrayList(this.groups.values());
                    this.groups = null;
                }
                for (GroupSubject groupSubject : localGroups) {
                    groupSubject.onCompleted();
                }
                s.onCompleted();
                this.unsubscribe();
            }
        };
    }

    public static final class GroupSubject<K, R>
    extends Subscriber<R> {
        final Observable<R> publishObservable;
        final SerializedObserver<R> publishSerial;
        final K key;

        static <K, R> GroupSubject<K, R> create(K key) {
            PublishSubject publish = PublishSubject.create();
            return new GroupSubject<K, R>(key, publish);
        }

        public GroupSubject(K key, Subject<R, R> publish) {
            this.key = key;
            this.publishObservable = publish;
            this.publishSerial = new SerializedObserver(publish);
        }

        public GroupedObservable<K, R> toObservable() {
            return new GroupedObservable(this.key, new Observable.OnSubscribe<R>(){

                @Override
                public void call(Subscriber<? super R> o) {
                    GroupSubject.this.publishObservable.unsafeSubscribe(o);
                }
            });
        }

        @Override
        public void onNext(R args) {
            this.publishSerial.onNext(args);
        }

        @Override
        public void onError(Throwable e) {
            this.publishSerial.onError(e);
        }

        @Override
        public void onCompleted() {
            this.publishSerial.onCompleted();
        }
    }
}

