/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeMapPair<T, U, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends Observable<? extends U>> collectionSelector;
    final Func2<? super T, ? super U, ? extends R> resultSelector;

    public static <T, U> Func1<T, Observable<U>> convertSelector(final Func1<? super T, ? extends Iterable<? extends U>> selector) {
        return new Func1<T, Observable<U>>(){

            @Override
            public Observable<U> call(T t1) {
                return Observable.from((Iterable)selector.call(t1));
            }
        };
    }

    public OperatorMergeMapPair(Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        this.collectionSelector = collectionSelector;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final SerializedSubscriber<? super R> s = new SerializedSubscriber<R>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        return new Subscriber<T>(child){
            final AtomicInteger wip;
            final Subscriber<?> self;
            {
                super(x0);
                this.wip = new AtomicInteger(1);
                this.self = this;
            }

            @Override
            public void onNext(final T t) {
                Observable collection;
                try {
                    collection = OperatorMergeMapPair.this.collectionSelector.call(t);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                Subscriber collectionSub = new Subscriber<U>(){

                    @Override
                    public void onNext(U u) {
                        try {
                            s.onNext(OperatorMergeMapPair.this.resultSelector.call(t, u));
                        }
                        catch (Throwable e) {
                            this.onError(e);
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        self.onError(e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        try {
                            self.onCompleted();
                        }
                        finally {
                            csub.remove(this);
                        }
                    }
                };
                csub.add(collectionSub);
                this.wip.incrementAndGet();
                collection.unsafeSubscribe(collectionSub);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                if (this.wip.decrementAndGet() == 0) {
                    s.onCompleted();
                }
            }
        };
    }
}

