/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.ConnectableObservable;
import rx.observers.SafeSubscriber;
import rx.operators.OperatorMulticast;
import rx.subjects.Subject;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMulticastSelector<TInput, TIntermediate, TResult>
implements Observable.OnSubscribe<TResult> {
    final Observable<? extends TInput> source;
    final Func0<? extends Subject<? super TInput, ? extends TIntermediate>> subjectFactory;
    final Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> resultSelector;

    public OperatorMulticastSelector(Observable<? extends TInput> source, Func0<? extends Subject<? super TInput, ? extends TIntermediate>> subjectFactory, Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> resultSelector) {
        this.source = source;
        this.subjectFactory = subjectFactory;
        this.resultSelector = resultSelector;
    }

    @Override
    public void call(Subscriber<? super TResult> child) {
        Observable<TResult> observable;
        OperatorMulticast<TInput, TIntermediate> connectable;
        try {
            Subject<? super TInput, ? extends TIntermediate> subject = this.subjectFactory.call();
            connectable = new OperatorMulticast<TInput, TIntermediate>(this.source, subject);
            observable = this.resultSelector.call(connectable);
        }
        catch (Throwable t) {
            child.onError(t);
            return;
        }
        CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        SafeSubscriber<? super TResult> s = new SafeSubscriber<TResult>(child);
        observable.unsafeSubscribe(s);
        csub.add(((ConnectableObservable)connectable).connect());
    }
}

