/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.operators.NotificationLite;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.TrampolineScheduler;

public class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;

    public OperatorObserveOn(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        return new ObserveOnSubscriber<T>(this.scheduler, child);
    }

    private static class ObserveOnSubscriber<T>
    extends Subscriber<T> {
        private final NotificationLite<T> on = NotificationLite.instance();
        final Subscriber<? super T> observer;
        private final Scheduler.Worker recursiveScheduler;
        private final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
        final AtomicLong counter = new AtomicLong(0L);

        public ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> subscriber) {
            super(subscriber);
            this.observer = subscriber;
            this.recursiveScheduler = scheduler.createWorker();
            subscriber.add(this.recursiveScheduler);
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(this.on.next(t));
            this.schedule();
        }

        @Override
        public void onCompleted() {
            this.queue.offer(this.on.completed());
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            this.queue.offer(this.on.error(e));
            this.schedule();
        }

        protected void schedule() {
            if (this.counter.getAndIncrement() == 0L) {
                this.recursiveScheduler.schedule(new Action0(){

                    @Override
                    public void call() {
                        ObserveOnSubscriber.this.pollQueue();
                    }
                });
            }
        }

        private void pollQueue() {
            do {
                Object v = this.queue.poll();
                this.on.accept(this.observer, v);
            } while (this.counter.decrementAndGet() > 0L);
        }
    }
}

