/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.schedulers.Schedulers;

public final class OperatorParallelMerge {
    private OperatorParallelMerge() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables) {
        return OperatorParallelMerge.parallelMerge(source, parallelObservables, Schedulers.immediate());
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, final int parallelObservables, final Scheduler scheduler) {
        return source.groupBy(new Func1<Observable<T>, Integer>(){
            final AtomicLong rollingCount = new AtomicLong();

            @Override
            public Integer call(Observable<T> o) {
                return (int)this.rollingCount.incrementAndGet() % parallelObservables;
            }
        }).map(new Func1<GroupedObservable<Integer, Observable<T>>, Observable<T>>(){

            @Override
            public Observable<T> call(GroupedObservable<Integer, Observable<T>> o) {
                return Observable.merge(o).observeOn(scheduler);
            }
        });
    }
}

