/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.schedulers.Timestamped;
import rx.subjects.Subject;

public final class OperatorReplay {
    private OperatorReplay() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Subject<T, T> replayBuffered(int bufferSize) {
        return CustomReplaySubject.create(bufferSize);
    }

    public static <T> Subject<T, T> createScheduledSubject(Subject<T, T> subject, Scheduler scheduler) {
        final Observable observedOn = subject.observeOn(scheduler);
        SubjectWrapper<T> s = new SubjectWrapper<T>(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> o) {
                OperatorReplay.subscriberOf(observedOn).call(o);
            }
        }, subject);
        return s;
    }

    public static <T> Subject<T, T> replayWindowed(long time, TimeUnit unit, int bufferSize, final Scheduler scheduler) {
        final long ms = unit.toMillis(time);
        if (ms <= 0L) {
            throw new IllegalArgumentException("The time window is less than 1 millisecond!");
        }
        Func1 timestamp = new Func1<T, Timestamped<T>>(){

            @Override
            public Timestamped<T> call(T t1) {
                return new Timestamped(scheduler.now(), t1);
            }
        };
        Func1 untimestamp = new Func1<Timestamped<T>, T>(){

            @Override
            public T call(Timestamped<T> t1) {
                return t1.getValue();
            }
        };
        ReplayState state = bufferSize >= 0 ? new ReplayState(new VirtualBoundedList(bufferSize), untimestamp) : new ReplayState(new VirtualArrayList(), untimestamp);
        final ReplayState fstate = state;
        state.onSubscription = state.onValueAdded = new Action0(){

            @Override
            public void call() {
                long now = scheduler.now();
                long before = now - ms;
                for (int i = fstate.values.start(); i < fstate.values.end(); ++i) {
                    Timestamped v = (Timestamped)fstate.values.get(i);
                    if (v.getTimestampMillis() < before) continue;
                    fstate.values.removeBefore(i);
                    break;
                }
            }
        };
        CustomReplaySubject brs = new CustomReplaySubject(new CustomReplaySubjectSubscribeFunc(state), state, timestamp);
        return brs;
    }

    public static <T> Observable.OnSubscribe<T> subscriberOf(final Observable<T> target) {
        return new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> t1) {
                target.unsafeSubscribe(t1);
            }
        };
    }

    protected static final class CustomReplaySubjectSubscribeFunc<TIntermediate, TResult>
    implements Observable.OnSubscribe<TResult> {
        private final ReplayState<TIntermediate, TResult> state;

        protected CustomReplaySubjectSubscribeFunc(ReplayState<TIntermediate, TResult> state) {
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(Subscriber<? super TResult> t1) {
            Throwable error;
            VirtualList values;
            this.state.lock();
            try {
                if (!this.state.done) {
                    this.state.onSubscription.call();
                    this.state.addReplayer(t1);
                    return;
                }
                values = this.state.values;
                error = this.state.error;
            }
            finally {
                this.state.unlock();
            }
            for (int i = values.start(); i < values.end(); ++i) {
                try {
                    t1.onNext(this.state.resultSelector.call(values.get(i)));
                    continue;
                }
                catch (Throwable t) {
                    t1.onError(t);
                    return;
                }
            }
            if (error != null) {
                t1.onError(error);
            } else {
                t1.onCompleted();
            }
        }
    }

    public static final class CustomReplaySubject<TInput, TIntermediate, TResult>
    extends Subject<TInput, TResult> {
        protected final ReplayState<TIntermediate, TResult> state;
        protected final Func1<? super TInput, ? extends TIntermediate> intermediateSelector;

        public static <T> CustomReplaySubject<T, T, T> create() {
            ReplayState state = new ReplayState(new VirtualArrayList(), Functions.identity());
            return new CustomReplaySubject(new CustomReplaySubjectSubscribeFunc(state), state, Functions.identity());
        }

        public static <T> CustomReplaySubject<T, T, T> create(int maxSize) {
            ReplayState state = new ReplayState(new VirtualBoundedList(maxSize), Functions.identity());
            return new CustomReplaySubject(new CustomReplaySubjectSubscribeFunc(state), state, Functions.identity());
        }

        private CustomReplaySubject(final Observable.OnSubscribe<TResult> onSubscribe, ReplayState<TIntermediate, TResult> state, Func1<? super TInput, ? extends TIntermediate> intermediateSelector) {
            super(new Observable.OnSubscribe<TResult>(){

                @Override
                public void call(Subscriber<? super TResult> sub) {
                    onSubscribe.call(sub);
                }
            });
            this.state = state;
            this.intermediateSelector = intermediateSelector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            this.state.lock();
            try {
                if (this.state.done) {
                    return;
                }
                this.state.done = true;
                this.state.onCompletedAdded.call();
                this.replayValues();
            }
            finally {
                this.state.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            this.state.lock();
            try {
                if (this.state.done) {
                    return;
                }
                this.state.done = true;
                this.state.error = e;
                this.state.onErrorAdded.call();
                this.replayValues();
            }
            finally {
                this.state.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(TInput args) {
            this.state.lock();
            try {
                if (this.state.done) {
                    return;
                }
                this.state.add(this.intermediateSelector.call(args));
                this.state.onValueAdded.call();
                this.replayValues();
            }
            finally {
                this.state.unlock();
            }
        }

        protected void replayValues() {
            int s = this.state.values.start() + this.state.values.size();
            for (ReplayState.Replayer rp : this.state.replayers()) {
                rp.replayTill(s);
            }
        }
    }

    static final class ReplayState<TIntermediate, TResult>
    extends BaseState {
        final VirtualList<TIntermediate> values;
        final Func1<? super TIntermediate, ? extends TResult> resultSelector;
        Throwable error;
        boolean done;
        final Map<Subscription, Replayer> replayers = new LinkedHashMap<Subscription, Replayer>();
        protected Action0 onValueAdded = new Action0(){

            @Override
            public void call() {
            }
        };
        protected Action0 onErrorAdded = new Action0(){

            @Override
            public void call() {
            }
        };
        protected Action0 onCompletedAdded = new Action0(){

            @Override
            public void call() {
            }
        };
        protected Action0 onSubscription = new Action0(){

            @Override
            public void call() {
            }
        };

        public ReplayState(VirtualList<TIntermediate> values, Func1<? super TIntermediate, ? extends TResult> resultSelector) {
            this.values = values;
            this.resultSelector = resultSelector;
        }

        Collection<Replayer> replayers() {
            return new ArrayList<Replayer>(this.replayers.values());
        }

        Subscription addReplayer(Subscriber<? super TResult> obs) {
            Subscription s = new Subscription(){
                final AtomicBoolean once = new AtomicBoolean();

                @Override
                public void unsubscribe() {
                    if (this.once.compareAndSet(false, true)) {
                        ReplayState.this.remove(this);
                    }
                }

                @Override
                public boolean isUnsubscribed() {
                    return this.once.get();
                }
            };
            obs.add(s);
            Replayer rp = new Replayer(obs, s);
            this.replayers.put(s, rp);
            rp.replayTill(this.values.start() + this.values.size());
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Subscription s) {
            this.lock();
            try {
                this.replayers.remove(s);
            }
            finally {
                this.unlock();
            }
        }

        void add(TIntermediate value) {
            this.values.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearValues() {
            this.lock();
            try {
                this.values.clear();
            }
            finally {
                this.unlock();
            }
        }

        final class Replayer {
            protected final Subscriber<? super TResult> wrapped;
            protected int index;
            protected final Subscription cancel;

            protected Replayer(Subscriber<? super TResult> wrapped, Subscription cancel) {
                this.wrapped = wrapped;
                this.cancel = cancel;
            }

            void replayTill(int limit) {
                int si = ReplayState.this.values.start();
                if (this.index < si) {
                    this.index = si;
                }
                while (this.index < limit) {
                    Object value = ReplayState.this.values.get(this.index);
                    ++this.index;
                    try {
                        this.wrapped.onNext(ReplayState.this.resultSelector.call(value));
                    }
                    catch (Throwable t) {
                        ReplayState.this.replayers.remove(this.cancel);
                        this.wrapped.onError(t);
                        return;
                    }
                }
                if (ReplayState.this.done) {
                    if (ReplayState.this.error != null) {
                        this.wrapped.onError(ReplayState.this.error);
                    } else {
                        this.wrapped.onCompleted();
                    }
                }
            }
        }
    }

    public static final class VirtualBoundedList<T>
    implements VirtualList<T> {
        private final List<T> list = new ArrayList<T>();
        private final int maxSize;
        int startIndex;
        int head;
        int tail;
        int count;

        public VirtualBoundedList(int maxSize) {
            if (maxSize < 0) {
                throw new IllegalArgumentException("maxSize < 0");
            }
            this.maxSize = maxSize;
        }

        @Override
        public int start() {
            return this.startIndex;
        }

        @Override
        public int end() {
            return this.startIndex + this.count;
        }

        @Override
        public void clear() {
            this.startIndex += this.count;
            this.list.clear();
            this.head = 0;
            this.tail = 0;
            this.count = 0;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void add(T value) {
            if (this.list.size() == this.maxSize) {
                this.list.set(this.tail, value);
                this.head = (this.head + 1) % this.maxSize;
                this.tail = (this.tail + 1) % this.maxSize;
                ++this.startIndex;
            } else {
                this.list.add(value);
                this.tail = (this.tail + 1) % this.maxSize;
                ++this.count;
            }
        }

        @Override
        public T get(int index) {
            if (index < this.start() || index >= this.end()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            int idx = (this.head + (index - this.startIndex)) % this.maxSize;
            return this.list.get(idx);
        }

        @Override
        public void removeBefore(int index) {
            if (index <= this.start()) {
                return;
            }
            if (index >= this.end()) {
                this.clear();
                this.startIndex = index;
                return;
            }
            int rc = index - this.startIndex;
            int head2 = this.head + rc;
            for (int i = this.head; i < head2; ++i) {
                this.list.set(i % this.maxSize, null);
                --this.count;
            }
            this.startIndex = index;
            this.head = head2 % this.maxSize;
        }

        @Override
        public List<T> toList() {
            ArrayList<T> r = new ArrayList<T>(this.list.size() + 1);
            for (int i = this.head; i < this.head + this.count; ++i) {
                int idx = i % this.maxSize;
                r.add(this.list.get(idx));
            }
            return r;
        }

        @Override
        public void reset() {
            this.list.clear();
            this.count = 0;
            this.head = 0;
            this.tail = 0;
        }
    }

    public static final class VirtualArrayList<T>
    implements VirtualList<T> {
        final List<T> list = new ArrayList<T>();
        int startIndex;

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void add(T value) {
            this.list.add(value);
        }

        @Override
        public T get(int index) {
            return this.list.get(index - this.startIndex);
        }

        @Override
        public void removeBefore(int index) {
            int j = index - this.startIndex;
            if (j > 0 && j <= this.list.size()) {
                this.list.subList(0, j).clear();
            }
            this.startIndex = index;
        }

        @Override
        public void clear() {
            this.startIndex += this.list.size();
            this.list.clear();
        }

        @Override
        public int start() {
            return this.startIndex;
        }

        @Override
        public int end() {
            return this.startIndex + this.list.size();
        }

        @Override
        public void reset() {
            this.list.clear();
            this.startIndex = 0;
        }

        @Override
        public List<T> toList() {
            return new ArrayList<T>(this.list);
        }
    }

    public static interface VirtualList<T> {
        public int size();

        public void add(T var1);

        public T get(int var1);

        public void removeBefore(int var1);

        public void clear();

        public int start();

        public int end();

        public void reset();

        public List<T> toList();
    }

    static class BaseState {
        private final Lock lock = new ReentrantLock();

        BaseState() {
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    public static final class SubjectWrapper<T>
    extends Subject<T, T> {
        final Subject<T, T> subject;

        public SubjectWrapper(Observable.OnSubscribe<T> func, Subject<T, T> subject) {
            super(func);
            this.subject = subject;
        }

        @Override
        public void onNext(T args) {
            this.subject.onNext(args);
        }

        @Override
        public void onError(Throwable e) {
            this.subject.onError(e);
        }

        @Override
        public void onCompleted() {
            this.subject.onCompleted();
        }
    }
}

