/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public class OperatorRetry<T>
implements Observable.Operator<T, Observable<T>> {
    private static final int INFINITE_RETRY = -1;
    private final int retryCount;
    private static Scheduler scheduler = Schedulers.trampoline();

    public OperatorRetry(int retryCount) {
        this.retryCount = retryCount;
    }

    public OperatorRetry() {
        this(-1);
    }

    @Override
    public Subscriber<? super Observable<T>> call(final Subscriber<? super T> child) {
        final Scheduler.Worker inner = scheduler.createWorker();
        child.add(inner);
        final SerialSubscription serialSubscription = new SerialSubscription();
        child.add(serialSubscription);
        return new Subscriber<Observable<T>>(child){
            final AtomicInteger attempts;
            {
                super(x0);
                this.attempts = new AtomicInteger(0);
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(final Observable<T> o) {
                inner.schedule(new Action0(){

                    @Override
                    public void call() {
                        final 1 _self = this;
                        attempts.incrementAndGet();
                        Subscriber subscriber = new Subscriber<T>(){

                            @Override
                            public void onCompleted() {
                                child.onCompleted();
                            }

                            @Override
                            public void onError(Throwable e) {
                                if (!(OperatorRetry.this.retryCount != -1 && attempts.get() > OperatorRetry.this.retryCount || inner.isUnsubscribed())) {
                                    inner.schedule(_self);
                                } else {
                                    child.onError(e);
                                }
                            }

                            @Override
                            public void onNext(T v) {
                                child.onNext(v);
                            }
                        };
                        serialSubscription.set(subscriber);
                        o.unsafeSubscribe(subscriber);
                    }
                });
            }
        };
    }
}

