/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import rx.Observable;
import rx.Subscriber;
import rx.operators.NotificationLite;

public class OperatorSkipLast<T>
implements Observable.Operator<T, T> {
    private final int count;

    public OperatorSkipLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private final NotificationLite<T> on;
            private final Deque<Object> deque;
            {
                super(x0);
                this.on = NotificationLite.instance();
                this.deque = new ArrayDeque<Object>();
            }

            @Override
            public void onCompleted() {
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (OperatorSkipLast.this.count == 0) {
                    subscriber.onNext(value);
                    return;
                }
                if (this.deque.size() == OperatorSkipLast.this.count) {
                    subscriber.onNext(this.on.getValue(this.deque.removeFirst()));
                }
                this.deque.offerLast(this.on.next(value));
            }
        };
    }
}

