/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OperatorSkipTimed<T>
implements Observable.Operator<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorSkipTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        final AtomicBoolean gate = new AtomicBoolean();
        worker.schedule(new Action0(){

            @Override
            public void call() {
                gate.set(true);
            }
        }, this.time, this.unit);
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                if (gate.get()) {
                    child.onNext(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    child.onError(e);
                }
                finally {
                    this.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    child.onCompleted();
                }
                finally {
                    this.unsubscribe();
                }
            }
        };
    }
}

