/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import rx.Observable;
import rx.Subscriber;
import rx.operators.NotificationLite;

public final class OperatorTakeLast<T>
implements Observable.Operator<T, T> {
    private final int count;

    public OperatorTakeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private NotificationLite<T> notification;
            private Deque<Object> deque;
            {
                super(x0);
                this.notification = NotificationLite.instance();
                this.deque = new ArrayDeque<Object>();
            }

            @Override
            public void onCompleted() {
                try {
                    for (Object value : this.deque) {
                        subscriber.onNext(this.notification.getValue(value));
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                this.deque.clear();
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.deque.clear();
                subscriber.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (OperatorTakeLast.this.count == 0) {
                    return;
                }
                if (this.deque.size() == OperatorTakeLast.this.count) {
                    this.deque.removeFirst();
                }
                this.deque.offerLast(this.notification.next(value));
            }
        };
    }
}

