/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;

public final class OperatorToMap<T, K, V>
implements Observable.Operator<Map<K, V>, T> {
    private final Func1<? super T, ? extends K> keySelector;
    private final Func1<? super T, ? extends V> valueSelector;
    private final Func0<? extends Map<K, V>> mapFactory;

    public OperatorToMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(keySelector, valueSelector, new DefaultToMapFactory());
    }

    public OperatorToMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.mapFactory = mapFactory;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Map<K, V>> subscriber) {
        return new Subscriber<T>(subscriber){
            private Map<K, V> map;
            {
                super(x0);
                this.map = (Map)OperatorToMap.this.mapFactory.call();
            }

            @Override
            public void onNext(T v) {
                Object key = OperatorToMap.this.keySelector.call(v);
                Object value = OperatorToMap.this.valueSelector.call(v);
                this.map.put(key, value);
            }

            @Override
            public void onError(Throwable e) {
                this.map = null;
                subscriber.onError(e);
            }

            @Override
            public void onCompleted() {
                Map map0 = this.map;
                this.map = null;
                subscriber.onNext(map0);
                subscriber.onCompleted();
            }
        };
    }

    public static final class DefaultToMapFactory<K, V>
    implements Func0<Map<K, V>> {
        @Override
        public Map<K, V> call() {
            return new HashMap();
        }
    }
}

