/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func0;
import rx.functions.Func1;

public final class OperatorUsing<T, Resource extends Subscription>
implements Observable.OnSubscribe<T> {
    private final Func0<Resource> resourceFactory;
    private final Func1<Resource, ? extends Observable<? extends T>> observableFactory;

    public OperatorUsing(Func0<Resource> resourceFactory, Func1<Resource, ? extends Observable<? extends T>> observableFactory) {
        this.resourceFactory = resourceFactory;
        this.observableFactory = observableFactory;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        Subscription resource = null;
        try {
            resource = (Subscription)this.resourceFactory.call();
            subscriber.add(resource);
            Observable<T> observable = this.observableFactory.call(resource);
            observable.subscribe(subscriber);
        }
        catch (Throwable e) {
            if (resource != null) {
                resource.unsubscribe();
            }
            subscriber.onError(e);
        }
    }
}

