/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.operators.SafeObservableSubscription;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.Subscriptions;

@Deprecated
public class SafeObserver<T>
extends Subscriber<T> {
    private final Observer<? super T> actual;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final Subscription subscription;

    public SafeObserver(Observer<? super T> actual) {
        this.subscription = Subscriptions.empty();
        this.actual = actual;
    }

    public SafeObserver(SafeObservableSubscription subscription, Observer<? super T> actual) {
        this.subscription = subscription;
        this.actual = actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.isFinished.compareAndSet(false, true)) {
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e) {
                this._onError(e);
            }
            finally {
                this.subscription.unsubscribe();
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.isFinished.compareAndSet(false, true)) {
            this._onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        try {
            if (!this.isFinished.get()) {
                this.actual.onNext(args);
            }
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    protected void _onError(Throwable e) {
        try {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            this.actual.onError(e);
        }
        catch (Throwable e2) {
            if (e2 instanceof OnErrorNotImplementedException) {
                try {
                    this.subscription.unsubscribe();
                }
                catch (Throwable unsubscribeException) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
                    throw new RuntimeException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(e, unsubscribeException)));
                }
                throw (OnErrorNotImplementedException)e2;
            }
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e2);
            try {
                this.subscription.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
                throw new RuntimeException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(e, e2, unsubscribeException)));
            }
            throw new RuntimeException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e, e2)));
        }
        try {
            this.subscription.unsubscribe();
        }
        catch (RuntimeException unsubscribeException) {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
            throw unsubscribeException;
        }
    }
}

