/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    final AtomicReference<Notification<T>> lastNotification;

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference<Notification<T>> lastNotification = new AtomicReference<Notification<T>>(Notification.createOnNext(defaultValue));
        Observable.OnSubscribe onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                Notification n = (Notification)lastNotification.get();
                if (n.isOnNext()) {
                    n.accept(o);
                }
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                ((Notification)lastNotification.get()).accept(o);
            }
        }, null);
        return new BehaviorSubject(onSubscribe, subscriptionManager, lastNotification);
    }

    protected BehaviorSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
    }

    @Override
    public void onCompleted() {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                BehaviorSubject.this.lastNotification.set(Notification.createOnCompleted());
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                observer.onCompleted();
            }
        }
    }

    @Override
    public void onError(final Throwable e) {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                BehaviorSubject.this.lastNotification.set(Notification.createOnError(e));
            }
        });
        if (observers != null) {
            for (Observer observer : observers) {
                observer.onError(e);
            }
        }
    }

    @Override
    public void onNext(T v) {
        if (this.lastNotification.get().isOnNext()) {
            this.lastNotification.set(Notification.createOnNext(v));
            for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
                o.onNext(v);
            }
        }
    }
}

