/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subscriptions.Subscriptions;

class SubjectSubscriptionManager<T> {
    private AtomicReference<State<T>> state = new AtomicReference(new State());

    SubjectSubscriptionManager() {
    }

    public Observable.OnSubscribe<T> getOnSubscribeFunc(final Action1<SubjectObserver<? super T>> onSubscribe, final Action1<SubjectObserver<? super T>> onTerminated, final Action1<SubjectObserver<? super T>> onUnsubscribe) {
        return new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> actualOperator) {
                State current;
                final SubjectObserver observer = new SubjectObserver(actualOperator);
                if (onSubscribe != null) {
                    onSubscribe.call(observer);
                }
                State newState = null;
                boolean addedObserver = false;
                do {
                    current = (State)SubjectSubscriptionManager.this.state.get();
                    if (current.terminated) {
                        addedObserver = false;
                        newState = current;
                        try {
                            current.terminationLatch.await();
                            break;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Interrupted waiting for termination.", e);
                        }
                    }
                    addedObserver = true;
                    actualOperator.add(Subscriptions.create(new Action0(){

                        @Override
                        public void call() {
                            State newState;
                            State current;
                            do {
                                current = (State)SubjectSubscriptionManager.this.state.get();
                                newState = current.removeObserver(observer);
                            } while (!SubjectSubscriptionManager.this.state.compareAndSet(current, newState));
                            if (onUnsubscribe != null) {
                                onUnsubscribe.call(observer);
                            }
                        }
                    }));
                    if (actualOperator.isUnsubscribed()) {
                        return;
                    }
                    newState = current.addObserver(observer);
                } while (!SubjectSubscriptionManager.this.state.compareAndSet(current, newState));
                if (newState.terminated && !addedObserver) {
                    onTerminated.call(observer);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<SubjectObserver<? super T>> terminate(Action0 onTerminate) {
        State<T> current;
        State<T> newState = null;
        do {
            current = this.state.get();
            if (!current.terminated) continue;
            return null;
        } while (!this.state.compareAndSet(current, newState = current.terminate()));
        List<SubjectObserver<? super T>> observerCollection = Arrays.asList(newState.observers);
        try {
            onTerminate.call();
        }
        finally {
            newState.terminationLatch.countDown();
        }
        return observerCollection;
    }

    public SubjectObserver<Object>[] rawSnapshot() {
        return this.state.get().observers;
    }

    protected static class SubjectObserver<T>
    implements Observer<T> {
        private final Observer<? super T> actual;
        protected volatile boolean caughtUp = false;
        boolean once = true;

        SubjectObserver(Observer<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onCompleted() {
            if (this.once) {
                this.once = false;
                this.actual.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.once) {
                this.once = false;
                this.actual.onError(e);
            }
        }

        @Override
        public void onNext(T v) {
            this.actual.onNext(v);
        }
    }

    protected static class State<T> {
        final boolean terminated;
        final CountDownLatch terminationLatch;
        final SubjectObserver[] observers;
        final SubjectObserver[] EMPTY_O = new SubjectObserver[0];

        private State(boolean isTerminated, CountDownLatch terminationLatch, SubjectObserver[] observers) {
            this.terminationLatch = terminationLatch;
            this.terminated = isTerminated;
            this.observers = observers;
        }

        State() {
            this.terminated = false;
            this.terminationLatch = null;
            this.observers = this.EMPTY_O;
        }

        public State<T> terminate() {
            if (this.terminated) {
                throw new IllegalStateException("Already terminated.");
            }
            return new State<T>(true, new CountDownLatch(1), this.observers);
        }

        public State<T> addObserver(SubjectObserver<? super T> observer) {
            int n = this.observers.length;
            SubjectObserver[] newobservers = Arrays.copyOf(this.observers, n + 1);
            newobservers[n] = observer;
            return this.createNewWith(newobservers);
        }

        private State<T> createNewWith(SubjectObserver[] newobservers) {
            return new State<T>(this.terminated, this.terminationLatch, newobservers);
        }

        public State<T> removeObserver(SubjectObserver<? super T> o) {
            if (this.observers.length == 0) {
                return this;
            }
            int n = this.observers.length - 1;
            int copied = 0;
            SubjectObserver[] newobservers = new SubjectObserver[n];
            for (int i = 0; i < this.observers.length; ++i) {
                SubjectObserver s0 = this.observers[i];
                if (s0.equals(o)) continue;
                if (copied == n) {
                    return this;
                }
                newobservers[copied] = s0;
                ++copied;
            }
            if (copied == 0) {
                return this.createNewWith(this.EMPTY_O);
            }
            if (copied < n) {
                SubjectObserver[] newobservers2 = new SubjectObserver[copied];
                System.arraycopy(newobservers, 0, newobservers2, 0, copied);
                return this.createNewWith(newobservers2);
            }
            return this.createNewWith(newobservers);
        }
    }
}

