/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Subscription;
import rx.functions.Action0;

public final class BooleanSubscription
implements Subscription {
    private final AtomicBoolean unsubscribed = new AtomicBoolean(false);
    private final Action0 action;

    public BooleanSubscription() {
        this.action = null;
    }

    private BooleanSubscription(Action0 action) {
        this.action = action;
    }

    public static BooleanSubscription create() {
        return new BooleanSubscription();
    }

    public static BooleanSubscription create(Action0 onUnsubscribe) {
        return new BooleanSubscription(onUnsubscribe);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed.get();
    }

    @Override
    public final void unsubscribe() {
        if (this.unsubscribed.compareAndSet(false, true) && this.action != null) {
            this.action.call();
        }
    }
}

