/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.Future;
import rx.Subscription;
import rx.functions.Action0;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;

public final class Subscriptions {
    private static Subscription EMPTY = new Subscription(){

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return false;
        }
    };

    public static Subscription empty() {
        return EMPTY;
    }

    public static Subscription create(final Action0 unsubscribe) {
        return new SafeObservableSubscription(new Subscription(){
            private volatile boolean unsubscribed = false;

            @Override
            public void unsubscribe() {
                this.unsubscribed = true;
                unsubscribe.call();
            }

            @Override
            public boolean isUnsubscribed() {
                return this.unsubscribed;
            }
        });
    }

    public static Subscription from(final Future<?> f) {
        return new Subscription(){

            @Override
            public void unsubscribe() {
                f.cancel(true);
            }

            @Override
            public boolean isUnsubscribed() {
                return f.isCancelled();
            }
        };
    }

    public static CompositeSubscription from(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }
}

