/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsRollingNumber {
    private static final Logger logger = LoggerFactory.getLogger(StatsRollingNumber.class);
    private static final int DEFAULT_TIME_IN_MILLIS = 10000;
    private static final int DEFAULT_BUCKETS = 10;
    private static final DynamicIntProperty defaultTimeInMilliseconds = DynamicPropertyFactory.getInstance().getIntProperty("turbine.StatsRollingNumber.defaultTimeInMilliseconds", 10000);
    private static final DynamicIntProperty defaultNumberOfBuckets = DynamicPropertyFactory.getInstance().getIntProperty("turbine.StatsRollingNumber.defaultBuckets", 10);
    private final DynamicIntProperty timeInMilliseconds;
    private final DynamicIntProperty numberOfBuckets;
    private final BucketCircularArray buckets;
    private ReentrantLock newBucketLock = new ReentrantLock();

    public StatsRollingNumber(DynamicIntProperty timeInMilliseconds) {
        this(timeInMilliseconds, defaultNumberOfBuckets);
    }

    public StatsRollingNumber(int timeInMilliseconds, int numberOfBuckets) {
        this(timeInMilliseconds == 10000 ? defaultTimeInMilliseconds : DynamicPropertyFactory.getInstance().getIntProperty("turbine.StatsRollingNumber.defaultTimeInMilliseconds", timeInMilliseconds), numberOfBuckets == 10 ? defaultNumberOfBuckets : DynamicPropertyFactory.getInstance().getIntProperty("turbine.StatsRollingNumber.defaultBuckets", numberOfBuckets));
    }

    public StatsRollingNumber(DynamicIntProperty timeInMilliseconds, DynamicIntProperty numberOfBuckets) {
        this.timeInMilliseconds = timeInMilliseconds;
        this.numberOfBuckets = numberOfBuckets;
        if (timeInMilliseconds.get() % numberOfBuckets.get() != 0) {
            throw new IllegalArgumentException("The timeInMilliseconds must divide equally into numberOfBuckets. For example 1000/10 is ok, 1000/11 is not.");
        }
        this.buckets = new BucketCircularArray(numberOfBuckets.get());
    }

    private int getBucketSizeInMilliseconds() {
        return this.timeInMilliseconds.get() / this.numberOfBuckets.get();
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets.get();
    }

    public int getRollingTimeInMilliseconds() {
        return this.timeInMilliseconds.get();
    }

    public void increment(Type type) {
        Bucket b = this.getCurrentBucket();
        b.get(type).incrementAndGet();
        b.flipModified(type);
    }

    public void increment(Type type, int delta) {
        Bucket b = this.getCurrentBucket();
        b.get(type).addAndGet(delta);
        b.flipModified(type);
    }

    public void set(Type type, int value) {
        Bucket b = this.getCurrentBucket();
        b.get(type).set(value);
        b.flipModified(type);
    }

    public boolean compareAndSet(Type type, int expected, int value) {
        return this.getCurrentBucket().get(type).compareAndSet(expected, value);
    }

    public void reset() {
        this.buckets.clear();
    }

    public int getCount(Type type) {
        return this.getSum(type);
    }

    public int getSum(Type type) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return 0;
        }
        int sum = 0;
        for (Bucket b : this.buckets) {
            sum += b.get(type).get();
        }
        return sum;
    }

    public int getValueOfLatestBucket(Type type) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return 0;
        }
        return lastBucket.get(type).get();
    }

    public int[] getValues(Type type) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return new int[0];
        }
        int[] values = new int[this.buckets.size()];
        int i = 0;
        for (Bucket bucket : this.buckets) {
            values[i++] = bucket.get(type).get();
        }
        return values;
    }

    public int[] getModifiedValues(Type type) {
        Bucket lastBucket = this.getCurrentBucket();
        if (lastBucket == null) {
            return new int[0];
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Bucket bucket : this.buckets) {
            if (!bucket.isModified(type)) continue;
            list.add(bucket.get(type).get());
        }
        int[] arr = new int[list.size()];
        int i = 0;
        for (Integer a : list) {
            arr[i++] = a;
        }
        return arr;
    }

    public int getMaxValue(Type type) {
        int[] values = this.getValues(type);
        if (values.length == 0) {
            return 0;
        }
        Arrays.sort(values);
        return values[values.length - 1];
    }

    public int getMinValue(Type type) {
        int[] values = this.getValues(type);
        if (values.length == 0) {
            return 0;
        }
        Arrays.sort(values);
        return values[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getCurrentBucket() {
        long currentTime = System.currentTimeMillis();
        Bucket currentBucket = this.buckets.peekLast();
        if (currentBucket != null && currentTime < currentBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
            return currentBucket;
        }
        if (this.newBucketLock.tryLock()) {
            try {
                if (this.buckets.peekLast() == null) {
                    Bucket newBucket = new Bucket(currentTime);
                    this.buckets.addLast(newBucket);
                    Bucket bucket = newBucket;
                    return bucket;
                }
                for (int i = 0; i < this.numberOfBuckets.get(); ++i) {
                    Bucket lastBucket = this.buckets.peekLast();
                    if (currentTime < lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
                        Bucket bucket = lastBucket;
                        return bucket;
                    }
                    if (currentTime - (lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) > (long)this.timeInMilliseconds.get()) {
                        this.reset();
                        Bucket bucket = this.getCurrentBucket();
                        return bucket;
                    }
                    this.buckets.addLast(new Bucket(lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()));
                    if (this.buckets.size() <= this.numberOfBuckets.get()) continue;
                    this.buckets.removeFirst();
                }
                Bucket i = this.buckets.peekLast();
                return i;
            }
            finally {
                this.newBucketLock.unlock();
            }
        }
        if (this.buckets.peekLast() != null) {
            return this.buckets.peekLast();
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.getCurrentBucket();
    }

    public static class UnitTest {
        @Test
        public void testCreatesBuckets() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                Assert.assertEquals((long)200L, (long)counter.timeInMilliseconds.get());
                Assert.assertEquals((long)10L, (long)counter.numberOfBuckets.get());
                Assert.assertEquals((long)20L, (long)counter.getBucketSizeInMilliseconds());
                Assert.assertEquals((long)0L, (long)counter.buckets.size());
                for (int i = 0; i < counter.numberOfBuckets.get(); ++i) {
                    counter.increment(Type.MAX_RATE);
                    Thread.sleep(counter.getBucketSizeInMilliseconds());
                }
                Assert.assertEquals((long)10L, (long)counter.buckets.size());
                counter.increment(Type.MAX_RATE);
                Assert.assertEquals((long)10L, (long)counter.buckets.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testResetBuckets() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                Assert.assertEquals((long)0L, (long)counter.buckets.size());
                counter.increment(Type.MAX_RATE);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                counter.increment(Type.MAX_RATE);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testEmptyBucketsFillIn() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.increment(Type.MAX_RATE);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                counter.increment(Type.MAX_RATE);
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testIncrementInSingleBucket() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.EVENT_DISCARDED);
                counter.increment(Type.EVENT_PROCESSED);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)4L, (long)counter.buckets.getLast().get(Type.MAX_RATE).get());
                Assert.assertEquals((long)2L, (long)counter.buckets.getLast().get(Type.MIN_RATE).get());
                Assert.assertEquals((long)1L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)1L, (long)counter.buckets.getLast().get(Type.EVENT_PROCESSED).get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testEVENT_DISCARDED() {
            this.testCounterType(Type.EVENT_DISCARDED);
        }

        @Test
        public void testEVENT_PROCESSED() {
            this.testCounterType(Type.EVENT_PROCESSED);
        }

        @Test
        public void testMAX_RATED() {
            this.testCounterType(Type.MAX_RATE);
        }

        @Test
        public void testMIN_RATE() {
            this.testCounterType(Type.MIN_RATE);
        }

        private void testCounterType(Type type) {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.increment(type);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)1L, (long)counter.buckets.getLast().get(type).get());
                Assert.assertEquals((long)1L, (long)counter.getCount(type));
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                counter.increment(type);
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
                Assert.assertEquals((long)1L, (long)counter.buckets.getLast().get(type).get());
                Assert.assertEquals((long)2L, (long)counter.getCount(type));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testIncrementInMultipleBuckets() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.EVENT_DISCARDED);
                counter.increment(Type.EVENT_PROCESSED);
                counter.increment(Type.EVENT_PROCESSED);
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.EVENT_DISCARDED);
                counter.increment(Type.EVENT_DISCARDED);
                counter.increment(Type.EVENT_PROCESSED);
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
                Assert.assertEquals((long)2L, (long)counter.buckets.getLast().get(Type.MAX_RATE).get());
                Assert.assertEquals((long)3L, (long)counter.buckets.getLast().get(Type.MIN_RATE).get());
                Assert.assertEquals((long)2L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)1L, (long)counter.buckets.getLast().get(Type.EVENT_PROCESSED).get());
                Assert.assertEquals((long)6L, (long)counter.getCount(Type.MAX_RATE));
                Assert.assertEquals((long)5L, (long)counter.getCount(Type.MIN_RATE));
                Assert.assertEquals((long)3L, (long)counter.getCount(Type.EVENT_DISCARDED));
                Assert.assertEquals((long)3L, (long)counter.getCount(Type.EVENT_PROCESSED));
                Thread.sleep(counter.timeInMilliseconds.get());
                counter.increment(Type.EVENT_DISCARDED);
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MAX_RATE));
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MIN_RATE));
                Assert.assertEquals((long)1L, (long)counter.getCount(Type.EVENT_DISCARDED));
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.EVENT_PROCESSED));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testCounterRetrievalRefreshesBuckets() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MAX_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.MIN_RATE);
                counter.increment(Type.EVENT_DISCARDED);
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)4L, (long)counter.getCount(Type.MAX_RATE));
                Assert.assertEquals((long)2L, (long)counter.getCount(Type.MIN_RATE));
                Assert.assertEquals((long)1L, (long)counter.getCount(Type.EVENT_DISCARDED));
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
                Thread.sleep(counter.timeInMilliseconds.get());
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MAX_RATE));
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MIN_RATE));
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.EVENT_DISCARDED));
                counter.increment(Type.EVENT_DISCARDED);
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MAX_RATE));
                Assert.assertEquals((long)0L, (long)counter.getCount(Type.MIN_RATE));
                Assert.assertEquals((long)1L, (long)counter.getCount(Type.EVENT_DISCARDED));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testSet() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.set(Type.EVENT_DISCARDED, 10);
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)10L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)10L, (long)counter.getCount(Type.EVENT_DISCARDED));
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                counter.set(Type.EVENT_DISCARDED, 20);
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
                Assert.assertEquals((long)20L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)30L, (long)counter.getCount(Type.EVENT_DISCARDED));
                int[] values = counter.getValues(Type.EVENT_DISCARDED);
                Assert.assertEquals((long)10L, (long)values[0]);
                Assert.assertEquals((long)0L, (long)values[1]);
                Assert.assertEquals((long)0L, (long)values[2]);
                Assert.assertEquals((long)20L, (long)values[3]);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testCompareAndSet() {
            try {
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.set(Type.EVENT_DISCARDED, 10);
                Assert.assertTrue((boolean)counter.compareAndSet(Type.EVENT_DISCARDED, 10, 30));
                Assert.assertFalse((boolean)counter.compareAndSet(Type.EVENT_DISCARDED, 10, 20));
                Assert.assertEquals((long)1L, (long)counter.buckets.size());
                Assert.assertEquals((long)30L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)30L, (long)counter.getCount(Type.EVENT_DISCARDED));
                Thread.sleep(counter.getBucketSizeInMilliseconds() * 3);
                Assert.assertFalse((boolean)counter.compareAndSet(Type.EVENT_DISCARDED, 10, 30));
                Assert.assertTrue((boolean)counter.compareAndSet(Type.EVENT_DISCARDED, 0, 30));
                int latestValue = counter.getValueOfLatestBucket(Type.EVENT_DISCARDED);
                Assert.assertTrue((boolean)counter.compareAndSet(Type.EVENT_DISCARDED, latestValue, 50));
                Assert.assertEquals((long)4L, (long)counter.buckets.size());
                Assert.assertEquals((long)50L, (long)counter.buckets.getLast().get(Type.EVENT_DISCARDED).get());
                Assert.assertEquals((long)50L, (long)counter.getValueOfLatestBucket(Type.EVENT_DISCARDED));
                int[] values = counter.getValues(Type.EVENT_DISCARDED);
                Assert.assertEquals((long)30L, (long)values[0]);
                Assert.assertEquals((long)0L, (long)values[1]);
                Assert.assertEquals((long)0L, (long)values[2]);
                Assert.assertEquals((long)50L, (long)values[3]);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testMaxValue() {
            try {
                Type type = Type.EVENT_DISCARDED;
                StatsRollingNumber counter = new StatsRollingNumber(200, 10);
                counter.set(type, 10);
                Thread.sleep(counter.getBucketSizeInMilliseconds());
                counter.set(type, 30);
                Thread.sleep(counter.getBucketSizeInMilliseconds());
                counter.set(type, 40);
                Thread.sleep(counter.getBucketSizeInMilliseconds());
                counter.set(type, 15);
                Assert.assertEquals((long)40L, (long)counter.getMaxValue(type));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        }

        @Test
        public void testEmptySum() {
            Type type = Type.EVENT_DISCARDED;
            StatsRollingNumber counter = new StatsRollingNumber(200, 10);
            Assert.assertEquals((long)0L, (long)counter.getSum(type));
        }

        @Test
        public void testEmptyLatestValue() {
            Type type = Type.EVENT_DISCARDED;
            StatsRollingNumber counter = new StatsRollingNumber(200, 10);
            Assert.assertEquals((long)0L, (long)counter.getValueOfLatestBucket(type));
        }

        @Test
        public void testRolling() {
            Type type = Type.EVENT_DISCARDED;
            StatsRollingNumber counter = new StatsRollingNumber(20, 2);
            for (int i = 0; i < 20; ++i) {
                counter.getCurrentBucket();
                try {
                    Thread.sleep(counter.getBucketSizeInMilliseconds());
                }
                catch (Exception e) {
                    // empty catch block
                }
                Assert.assertEquals((long)2L, (long)counter.getValues(type).length);
                counter.getValueOfLatestBucket(type);
            }
        }
    }

    private class BucketCircularArray
    implements Iterable<Bucket> {
        private final AtomicReferenceArray<Bucket> data;
        private final AtomicReference<ListState> state;
        private final int length;

        BucketCircularArray(int size) {
            this.data = new AtomicReferenceArray(size + 5);
            this.state = new AtomicReference<ListState>(new ListState(0, 0));
            this.length = this.data.length();
        }

        public void clear() {
            this.state.set(new ListState(0, 0));
        }

        public int size() {
            return this.state.get().size;
        }

        public Bucket peekLast() {
            if (this.state.get().size == 0) {
                return null;
            }
            return this.data.get(this.convert(this.size() - 1, this.state.get()));
        }

        @Override
        public Iterator<Bucket> iterator() {
            return Collections.unmodifiableList(Arrays.asList(this.getArray())).iterator();
        }

        public void addLast(Bucket o) {
            ListState currentState = this.state.get();
            this.data.set(currentState.tail, o);
            ListState newState = currentState.incrementTail();
            if (this.state.compareAndSet(currentState, newState)) {
                if (this.data.compareAndSet(currentState.tail, o, o)) {
                    return;
                }
                logger.warn("Lost a thread-race ... this method should not be called concurrently.");
            } else {
                logger.warn("Lost a thread-race ... this method should not be called concurrently.");
            }
        }

        public Bucket removeFirst() {
            ListState currentState = this.state.get();
            Bucket toRemove = this.data.get(currentState.head);
            ListState newState = currentState.incrementHead();
            if (this.state.compareAndSet(currentState, newState)) {
                return toRemove;
            }
            logger.warn("Lost a thread-race ... this method should not be called concurrently.");
            return toRemove;
        }

        public Bucket getLast() {
            return this.peekLast();
        }

        private Bucket[] getArray() {
            ArrayList<Bucket> array = new ArrayList<Bucket>();
            ListState lState = this.state.get();
            for (int i = 0; i < lState.size; ++i) {
                array.add(this.data.get(this.convert(i, lState)));
            }
            return array.toArray(new Bucket[array.size()]);
        }

        private int convert(int index, ListState state) {
            return (index + state.head) % this.length;
        }

        private class ListState {
            private final int size;
            private final int tail;
            private final int head;

            public ListState(int head, int tail) {
                this.head = head;
                this.tail = tail;
                this.size = head == 0 && tail == 0 ? 0 : (tail + BucketCircularArray.this.length - head) % BucketCircularArray.this.length;
            }

            public ListState incrementTail() {
                return new ListState(this.head, (this.tail + 1) % BucketCircularArray.this.length);
            }

            public ListState incrementHead() {
                return new ListState((this.head + 1) % BucketCircularArray.this.length, this.tail);
            }
        }
    }

    private static class Bucket {
        final long windowStart;
        final AtomicInteger[] atomicIntegerForCounterType;
        final AtomicBoolean[] isModified;

        Bucket(long startTime) {
            this.windowStart = startTime;
            this.atomicIntegerForCounterType = new AtomicInteger[Type.values().length];
            this.isModified = new AtomicBoolean[Type.values().length];
            for (Type type : Type.values()) {
                this.atomicIntegerForCounterType[type.ordinal()] = new AtomicInteger();
                this.isModified[type.ordinal()] = new AtomicBoolean(false);
            }
        }

        AtomicInteger get(Type type) {
            return this.atomicIntegerForCounterType[type.ordinal()];
        }

        void flipModified(Type type) {
            AtomicBoolean modified = this.isModified[type.ordinal()];
            if (!modified.get()) {
                modified.compareAndSet(false, true);
            }
        }

        boolean isModified(Type type) {
            return this.isModified[type.ordinal()].get();
        }
    }

    public static enum Type {
        MAX_RATE,
        MIN_RATE,
        EVENT_DISCARDED,
        EVENT_PROCESSED;

    }
}

