/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data.meta;

import com.netflix.turbine.data.AggDataFromCluster;
import com.netflix.turbine.data.meta.MetaInfoAdaptor;
import com.netflix.turbine.data.meta.MetaInformation;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AggDataMetaInfoAdaptor
implements MetaInfoAdaptor<AggDataFromCluster> {
    private final AggDataMetaInfo metaData;

    public AggDataMetaInfoAdaptor(ClusterMonitor<AggDataFromCluster> cMonitor) {
        this.metaData = new AggDataMetaInfo(cMonitor);
    }

    @Override
    public AggDataFromCluster getData(MetaInformation<AggDataFromCluster> metaInfo) {
        this.metaData.update(metaInfo);
        return this.metaData;
    }

    private class AggDataMetaInfo
    extends AggDataFromCluster {
        private final AtomicReference<MetaInformation<AggDataFromCluster>> metaInfoReference;

        private AggDataMetaInfo(TurbineDataMonitor<AggDataFromCluster> monitor) {
            super(monitor, "meta", "meta");
            this.metaInfoReference = new AtomicReference<Object>(null);
        }

        @Override
        public HashMap<String, Long> getNumericAttributes() {
            HashMap<String, Long> nAttrs = new HashMap<String, Long>();
            MetaInformation<AggDataFromCluster> mInfo = this.metaInfoReference.get();
            if (mInfo != null) {
                nAttrs.put("reportingHostsLast10Seconds", mInfo.getReportingHosts());
                nAttrs.put("timestamp", mInfo.getLastUpdateTime());
            }
            return nAttrs;
        }

        @Override
        public HashMap<String, String> getStringAttributes() {
            return null;
        }

        @Override
        public HashMap<String, Map<String, ? extends Number>> getNestedMapAttributes() {
            return null;
        }

        private void update(MetaInformation<AggDataFromCluster> mInfo) {
            this.metaInfoReference.set(mInfo);
        }
    }
}

