/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.init;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.data.meta.MetaInfoUpdator;
import com.netflix.turbine.discovery.ConfigPropertyBasedDiscovery;
import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.discovery.InstanceObservable;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import com.netflix.turbine.monitor.instance.InstanceMonitor;
import com.netflix.turbine.monitor.instance.StaleConnectionMonitorReaper;
import com.netflix.turbine.plugins.DefaultAggregatorFactory;
import com.netflix.turbine.plugins.PluginsFactory;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurbineInit {
    private static final Logger logger = LoggerFactory.getLogger(TurbineInit.class);
    private static final DynamicStringProperty InstanceDiscoveryClassProp = DynamicPropertyFactory.getInstance().getStringProperty("InstanceDiscovery.impl", null);

    public static void init() {
        ClusterMonitorFactory<?> clusterMonitorFactory = PluginsFactory.getClusterMonitorFactory();
        if (clusterMonitorFactory == null) {
            PluginsFactory.setClusterMonitorFactory(new DefaultAggregatorFactory());
        }
        PluginsFactory.getClusterMonitorFactory().initClusterMonitors();
        InstanceDiscovery instanceDiscovery = PluginsFactory.getInstanceDiscovery();
        if (instanceDiscovery == null) {
            PluginsFactory.setInstanceDiscovery(TurbineInit.getInstanceDiscoveryImpl());
        }
        InstanceObservable.getInstance().start(PluginsFactory.getInstanceDiscovery());
    }

    public static void stop() {
        PluginsFactory.getClusterMonitorFactory().shutdownClusterMonitors();
        InstanceMonitor.stop();
        InstanceObservable.getInstance().stop();
        StaleConnectionMonitorReaper.Instance.stop();
        if (ConfigurationManager.getConfigInstance() instanceof DynamicConfiguration) {
            ((DynamicConfiguration)ConfigurationManager.getConfigInstance()).stopLoading();
        }
        if (ConfigurationManager.getConfigInstance() instanceof ConcurrentCompositeConfiguration) {
            ConcurrentCompositeConfiguration config = (ConcurrentCompositeConfiguration)ConfigurationManager.getConfigInstance();
            for (AbstractConfiguration innerConfig : config.getConfigurations()) {
                if (!(innerConfig instanceof DynamicConfiguration)) continue;
                ((DynamicConfiguration)innerConfig).stopLoading();
            }
        }
        MetaInfoUpdator.Instance.stop();
    }

    private static InstanceDiscovery getInstanceDiscoveryImpl() {
        String className = InstanceDiscoveryClassProp.get();
        if (className == null) {
            logger.info("Property " + InstanceDiscoveryClassProp.getName() + " is not defined, hence using " + ConfigPropertyBasedDiscovery.class.getSimpleName() + " as InstanceDiscovery impl");
            return new ConfigPropertyBasedDiscovery();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (InstanceDiscovery)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("Could not load InstanceDiscovery impl class", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

