/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MonitorConsole<K extends TurbineData> {
    private ConcurrentHashMap<String, TurbineDataMonitor<K>> registry = new ConcurrentHashMap();
    private AtomicInteger monitorCount = new AtomicInteger(0);

    public Collection<TurbineDataMonitor<K>> getAllMonitors() {
        return this.registry.values();
    }

    @Monitor(name="numMonitors", type=DataSourceType.GAUGE)
    int getNumberOfMonitors() {
        return this.monitorCount.get();
    }

    public TurbineDataMonitor<K> findOrRegisterMonitor(TurbineDataMonitor<K> monitor) {
        TurbineDataMonitor<K> previous = this.registry.putIfAbsent(monitor.getName(), monitor);
        if (previous != null) {
            return previous;
        }
        this.monitorCount.incrementAndGet();
        return monitor;
    }

    public TurbineDataMonitor<K> findMonitor(String name) {
        return this.registry.get(name);
    }

    public TurbineDataMonitor<K> removeMonitor(String name) {
        TurbineDataMonitor<K> prev = this.registry.remove(name);
        if (prev != null) {
            this.monitorCount.decrementAndGet();
        }
        return this.registry.remove(name);
    }

    public String toString() {
        return this.registry.keySet().toString();
    }

    public static class UnitTest {
        TurbineDataMonitor<DataFromSingleInstance> monitor;

        private void doTheMockMagic() throws Exception {
            this.monitor = (TurbineDataMonitor)Mockito.mock(TurbineDataMonitor.class);
            Mockito.when((Object)this.monitor.getName()).thenReturn((Object)"publisher");
        }

        private TurbineDataMonitor<DataFromSingleInstance> getMockMonitor() throws Exception {
            TurbineDataMonitor monitorNew = (TurbineDataMonitor)Mockito.mock(TurbineDataMonitor.class);
            Mockito.when((Object)monitorNew.getName()).thenReturn((Object)"publisher");
            return monitorNew;
        }

        @Test
        public void testFindOrStartMonitorIsIdempotent() throws Exception {
            this.doTheMockMagic();
            MonitorConsole<DataFromSingleInstance> console = new MonitorConsole<DataFromSingleInstance>();
            Assert.assertNull(console.findMonitor("publisher"));
            TurbineDataMonitor<DataFromSingleInstance> newMonitor = console.findOrRegisterMonitor(this.monitor);
            newMonitor.startMonitor();
            Thread.sleep(200L);
            Assert.assertNotNull(console.findMonitor("publisher"));
            Assert.assertTrue((newMonitor == this.monitor ? 1 : 0) != 0);
            this.monitor.stopMonitor();
        }

        @Test
        public void testFindOrStartMonitorIsThreadSafe() throws Exception {
            this.doTheMockMagic();
            ArrayList<Future<Pair>> results = new ArrayList<Future<Pair>>();
            ExecutorService executor = Executors.newFixedThreadPool(200);
            final MonitorConsole console = new MonitorConsole();
            for (int i = 0; i < 200; ++i) {
                results.add(executor.submit(new Callable<Pair>(){

                    @Override
                    public Pair call() throws Exception {
                        TurbineDataMonitor origMonitor = UnitTest.this.getMockMonitor();
                        TurbineDataMonitor<DataFromSingleInstance> returnMonitor = console.findOrRegisterMonitor(origMonitor);
                        returnMonitor.startMonitor();
                        class Pair {
                            private TurbineDataMonitor<DataFromSingleInstance> origMonitor;
                            private TurbineDataMonitor<DataFromSingleInstance> returnMonitor;

                            Pair(TurbineDataMonitor<DataFromSingleInstance> origMonitor, TurbineDataMonitor<DataFromSingleInstance> returnMonitor) {
                                this.origMonitor = origMonitor;
                                this.returnMonitor = returnMonitor;
                            }
                        }
                        return new Pair(origMonitor, returnMonitor);
                    }
                }));
            }
            TurbineDataMonitor runningMonitor = ((Pair)((Future)results.iterator().next()).get()).returnMonitor;
            Thread.sleep(200L);
            for (Future future : results) {
                TurbineDataMonitor returnMonitor = ((Pair)future.get()).returnMonitor;
                Assert.assertTrue((returnMonitor == runningMonitor ? 1 : 0) != 0);
            }
            runningMonitor.stopMonitor();
        }
    }
}

