/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor;

import com.netflix.turbine.data.StatsRollingNumber;
import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.handler.TurbineDataDispatcher;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TurbineDataMonitor<K extends TurbineData> {
    private StatsRollingNumber counter = new StatsRollingNumber(10000, 10);
    private ConcurrentHashMap<String, StatsRollingNumber> numbersWith2minuteWindow = new ConcurrentHashMap();

    public abstract String getName();

    public abstract void startMonitor() throws Exception;

    public abstract void stopMonitor();

    public abstract TurbineDataDispatcher<K> getDispatcher();

    public abstract Instance getStatsInstance();

    public void markEventDiscarded() {
        this.counter.increment(StatsRollingNumber.Type.EVENT_DISCARDED);
    }

    public void markEventProcessed() {
        this.counter.increment(StatsRollingNumber.Type.EVENT_PROCESSED);
    }

    public int getEventDiscarded() {
        return this.counter.getCount(StatsRollingNumber.Type.EVENT_DISCARDED);
    }

    public int getEventProcessed() {
        return this.counter.getCount(StatsRollingNumber.Type.EVENT_PROCESSED);
    }

    public StatsRollingNumber getRolling2MinuteStats(TurbineData data) {
        StatsRollingNumber rollingNumber = this.numbersWith2minuteWindow.get(data.getName());
        if (rollingNumber == null) {
            int statsWindow = 120000;
            int numberOfBuckets = statsWindow / 1000;
            rollingNumber = new StatsRollingNumber(statsWindow, numberOfBuckets);
            StatsRollingNumber previous = this.numbersWith2minuteWindow.putIfAbsent(data.getName(), rollingNumber);
            if (previous != null) {
                rollingNumber = previous;
            }
        }
        return rollingNumber;
    }

    public long getLastEventUpdateTime() {
        return -1L;
    }
}

