/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.cluster;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.turbine.data.AggDataFromCluster;
import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.data.meta.MetaInfoUpdator;
import com.netflix.turbine.data.meta.MetaInformation;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceObservable;
import com.netflix.turbine.handler.TurbineDataDispatcher;
import com.netflix.turbine.handler.TurbineDataHandler;
import com.netflix.turbine.monitor.MonitorConsole;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.ObservationCriteria;
import com.netflix.turbine.monitor.instance.InstanceMonitor;
import com.netflix.turbine.monitor.instance.InstanceUrlClosure;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterMonitor<K extends TurbineData>
extends TurbineDataMonitor<K> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterMonitor.class);
    protected final String name;
    protected final TurbineDataDispatcher<K> clusterDispatcher;
    protected final MonitorConsole<K> clusterConsole;
    protected final TurbineDataDispatcher<DataFromSingleInstance> hostDispatcher;
    protected final MonitorConsole<DataFromSingleInstance> hostConsole;
    protected volatile boolean stopped = false;
    protected final Instance statsInstance;
    protected final InstanceObservable instanceObservable;
    protected final InstanceUrlClosure urlClosure;
    protected final InstanceObservable.InstanceObserver monitorManager;
    private final AtomicInteger hostCount = new AtomicInteger(0);

    public ClusterMonitor(String name, TurbineDataDispatcher<K> clusterDispatcher, MonitorConsole<K> clusterConsole, TurbineDataDispatcher<DataFromSingleInstance> hostDispatcher, MonitorConsole<DataFromSingleInstance> hostConsole, InstanceUrlClosure urlClosure) {
        this(name, clusterDispatcher, clusterConsole, hostDispatcher, hostConsole, urlClosure, InstanceObservable.getInstance());
    }

    protected ClusterMonitor(String name, TurbineDataDispatcher<K> cDispatcher, MonitorConsole<K> cConsole, TurbineDataDispatcher<DataFromSingleInstance> hDispatcher, MonitorConsole<DataFromSingleInstance> hConsole, InstanceUrlClosure urlClosure, InstanceObservable instanceObservable) {
        this.name = name;
        this.clusterDispatcher = cDispatcher;
        this.clusterConsole = cConsole;
        this.hostDispatcher = hDispatcher;
        this.hostConsole = hConsole;
        this.urlClosure = urlClosure;
        this.instanceObservable = instanceObservable;
        this.monitorManager = new ClusterMonitorInstanceManager();
        this.statsInstance = new Instance(name, "clustetAgg", true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Instance getStatsInstance() {
        return this.statsInstance;
    }

    @Override
    public void startMonitor() throws Exception {
        logger.info("Starting up the cluster monitor for " + this.name);
        this.instanceObservable.register(this.monitorManager);
        MetaInformation<K> metaInfo = this.getMetaInformation();
        if (metaInfo != null) {
            MetaInfoUpdator.addMetaInfo(metaInfo);
        }
    }

    @Override
    public void stopMonitor() {
        logger.info("Stopping cluster monitor for " + this.name);
        this.stopped = true;
        this.instanceObservable.deregister(this.monitorManager);
        this.clusterDispatcher.handleHostLost(this.getStatsInstance());
        this.hostDispatcher.deregisterEventHandler(this.getEventHandler());
        this.clusterConsole.removeMonitor(this.getName());
        this.clusterDispatcher.stopDispatcher();
        MetaInformation<K> metaInfo = this.getMetaInformation();
        if (metaInfo != null) {
            MetaInfoUpdator.removeMetaInfo(metaInfo);
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(new ObjectName("ClusterMonitorMBean:name=ClusterMonitorStats_" + this.name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MonitorConsole<DataFromSingleInstance> getInstanceMonitors() {
        return this.hostConsole;
    }

    @Monitor(name="hostCount", type=DataSourceType.GAUGE)
    public int getHostCount() {
        return this.hostCount.get();
    }

    public boolean isRunning() {
        return this.clusterDispatcher.running();
    }

    @Override
    public TurbineDataDispatcher<K> getDispatcher() {
        return this.clusterDispatcher;
    }

    public abstract TurbineDataHandler<DataFromSingleInstance> getEventHandler();

    public abstract ObservationCriteria getObservationCriteria();

    public void registerListenertoClusterMonitor(TurbineDataHandler<K> eventHandler) {
        TurbineDataHandler<K> oldHandler = this.getDispatcher().findHandlerForHost(this.getStatsInstance(), eventHandler.getName());
        if (oldHandler == null) {
            logger.info("Registering event handler for cluster monitor: " + eventHandler.getName());
            this.getDispatcher().registerEventHandler(this.getStatsInstance(), eventHandler);
            logger.info("All event handlers for cluster monitor: " + this.getDispatcher().getAllHandlerNames().toString());
        } else {
            logger.info("Handler: " + oldHandler.getName() + " already registered to host: " + this.getStatsInstance());
        }
    }

    protected MetaInformation<K> getMetaInformation() {
        return null;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        private TurbineDataDispatcher<AggDataFromCluster> cDispatcher;
        @Mock
        private MonitorConsole<AggDataFromCluster> cConsole;
        @Mock
        private TurbineDataDispatcher<DataFromSingleInstance> hDispatcher;
        @Mock
        private MonitorConsole<DataFromSingleInstance> hConsole;
        @Mock
        private InstanceObservable iObservable;
        protected InstanceUrlClosure testUrlClosure = new InstanceUrlClosure(){

            @Override
            public String getUrlPath(Instance host) {
                return "";
            }
        };
        @Mock
        private TurbineDataHandler<DataFromSingleInstance> handler;
        @Mock
        private ObservationCriteria mCriteria;

        @Test
        public void testCleanStartupAndShutdown() throws Exception {
            TestClusterMonitor monitor = new TestClusterMonitor();
            monitor.startMonitor();
            ((InstanceObservable)Mockito.verify((Object)this.iObservable)).register(monitor.monitorManager);
            monitor.stopMonitor();
            ((InstanceObservable)Mockito.verify((Object)this.iObservable)).deregister(monitor.monitorManager);
            ((TurbineDataDispatcher)Mockito.verify(this.cDispatcher)).handleHostLost(monitor.statsInstance);
            ((TurbineDataDispatcher)Mockito.verify(this.cDispatcher)).stopDispatcher();
            ((TurbineDataDispatcher)Mockito.verify(this.hDispatcher)).deregisterEventHandler(this.handler);
            ((MonitorConsole)Mockito.verify(this.cConsole)).removeMonitor(monitor.getName());
        }

        @Test
        public void testHostUp() throws Exception {
            InstanceMonitor hostMon = (InstanceMonitor)Mockito.mock(InstanceMonitor.class);
            Mockito.when(this.hConsole.findMonitor((String)Matchers.any(String.class))).thenReturn((Object)hostMon);
            Mockito.when((Object)this.mCriteria.observeHost((Instance)Matchers.any(Instance.class))).thenReturn((Object)true);
            TestClusterMonitor monitor = new TestClusterMonitor();
            Instance host1 = new Instance("testHost1", "testCluster", true);
            monitor.monitorManager.hostsUp(Collections.singletonList(host1));
            ((MonitorConsole)Mockito.verify(this.hConsole)).findMonitor(host1.getHostname());
            ((InstanceMonitor)Mockito.verify((Object)hostMon)).startMonitor();
            ((TurbineDataDispatcher)Mockito.verify(this.hDispatcher)).registerEventHandler(host1, this.handler);
        }

        @Test
        public void testHostDown() throws Exception {
            Instance host1 = new Instance("testHost1", "testCluster", false);
            InstanceMonitor hostMon = (InstanceMonitor)Mockito.mock(InstanceMonitor.class);
            Mockito.when(this.hConsole.findMonitor((String)Matchers.any(String.class))).thenReturn((Object)hostMon);
            Mockito.when((Object)hostMon.getName()).thenReturn((Object)host1.getHostname());
            TestClusterMonitor monitor = new TestClusterMonitor();
            monitor.monitorManager.hostsDown(Collections.singletonList(host1));
            ((MonitorConsole)Mockito.verify(this.hConsole)).findMonitor(host1.getHostname());
            ((InstanceMonitor)Mockito.verify((Object)hostMon)).stopMonitor();
            ((MonitorConsole)Mockito.verify(this.hConsole)).removeMonitor("testHost1");
        }

        private class TestClusterMonitor
        extends ClusterMonitor<AggDataFromCluster> {
            public TestClusterMonitor() {
                super("testMonitor", UnitTest.this.cDispatcher, UnitTest.this.cConsole, UnitTest.this.hDispatcher, UnitTest.this.hConsole, UnitTest.this.testUrlClosure, UnitTest.this.iObservable);
            }

            @Override
            public TurbineDataHandler<DataFromSingleInstance> getEventHandler() {
                return UnitTest.this.handler;
            }

            @Override
            public ObservationCriteria getObservationCriteria() {
                return UnitTest.this.mCriteria;
            }
        }
    }

    public class ClusterMonitorInstanceManager
    implements InstanceObservable.InstanceObserver {
        @Override
        public String getName() {
            return ClusterMonitor.this.name;
        }

        public void hostUp(Instance host) {
            block4: {
                if (!ClusterMonitor.this.getObservationCriteria().observeHost(host)) {
                    return;
                }
                TurbineDataMonitor<DataFromSingleInstance> monitor = this.getMonitor(host);
                try {
                    if (ClusterMonitor.this.hostDispatcher.findHandlerForHost(host, ClusterMonitor.this.getEventHandler().getName()) == null) {
                        ClusterMonitor.this.hostDispatcher.registerEventHandler(host, ClusterMonitor.this.getEventHandler());
                    }
                    monitor.startMonitor();
                }
                catch (Throwable t) {
                    logger.info("Failed to start monitor: " + monitor.getName() + ", ex message: ", t);
                    monitor.stopMonitor();
                    logger.info("Removing monitor from stats event console");
                    TurbineDataMonitor<DataFromSingleInstance> oldMonitor = ClusterMonitor.this.hostConsole.removeMonitor(monitor.getName());
                    if (oldMonitor == null) break block4;
                    ClusterMonitor.this.hostCount.decrementAndGet();
                }
            }
        }

        public void hostDown(Instance host) {
            TurbineDataMonitor<DataFromSingleInstance> hostMonitor = ClusterMonitor.this.hostConsole.findMonitor(host.getHostname());
            if (hostMonitor != null) {
                ClusterMonitor.this.hostCount.decrementAndGet();
                hostMonitor.stopMonitor();
                logger.info("Removing monitor from stats event console");
                ClusterMonitor.this.hostConsole.removeMonitor(hostMonitor.getName());
            }
        }

        private TurbineDataMonitor<DataFromSingleInstance> getMonitor(Instance host) {
            InstanceMonitor monitor = ClusterMonitor.this.hostConsole.findMonitor(host.getHostname());
            if (monitor == null) {
                monitor = new InstanceMonitor(host, ClusterMonitor.this.urlClosure, ClusterMonitor.this.hostDispatcher, ClusterMonitor.this.hostConsole);
                ClusterMonitor.this.hostCount.incrementAndGet();
                return ClusterMonitor.this.hostConsole.findOrRegisterMonitor(monitor);
            }
            return monitor;
        }

        @Override
        public void hostsUp(Collection<Instance> hosts) {
            for (Instance host : hosts) {
                try {
                    this.hostUp(host);
                }
                catch (Throwable t) {
                    logger.error("Could not start monitor on hostUp: " + host.toString(), t);
                }
            }
        }

        @Override
        public void hostsDown(Collection<Instance> hosts) {
            for (Instance host : hosts) {
                try {
                    this.hostDown(host);
                }
                catch (Throwable t) {
                    logger.error("Could not stop monitor on hostDown: " + host.toString(), t);
                }
            }
        }
    }
}

