/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.util.Pair;
import com.netflix.zuul.util.DeepCopy;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext
extends ConcurrentHashMap<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContext.class);
    protected static Class<? extends RequestContext> contextClass = RequestContext.class;
    private static RequestContext testContext = null;
    protected static final ThreadLocal<? extends RequestContext> threadLocal = new ThreadLocal<RequestContext>(){

        @Override
        protected RequestContext initialValue() {
            try {
                return contextClass.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static void setContextClass(Class<? extends RequestContext> clazz) {
        contextClass = clazz;
    }

    public static void testSetCurrentContext(RequestContext context) {
        testContext = context;
    }

    public static RequestContext getCurrentContext() {
        if (testContext != null) {
            return testContext;
        }
        RequestContext context = threadLocal.get();
        return context;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultResponse) {
        Boolean b = (Boolean)this.get(key);
        if (b != null) {
            return b;
        }
        return defaultResponse;
    }

    public void set(String key) {
        this.put(key, Boolean.TRUE);
    }

    public void set(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public boolean getZuulEngineRan() {
        return this.getBoolean("zuulEngineRan");
    }

    public void setZuulEngineRan() {
        this.put("zuulEngineRan", true);
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.get("request");
    }

    public void setRequest(HttpServletRequest request) {
        this.put("request", request);
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.get("response");
    }

    public void setResponse(HttpServletResponse response) {
        this.set("response", response);
    }

    public Throwable getThrowable() {
        return (Throwable)this.get("throwable");
    }

    public void setThrowable(Throwable th) {
        this.put("throwable", th);
    }

    public void setDebugRouting(boolean bDebug) {
        this.set("debugRouting", bDebug);
    }

    public boolean debugRouting() {
        return this.getBoolean("debugRouting");
    }

    public void setDebugRequestHeadersOnly(boolean bHeadersOnly) {
        this.set("debugRequestHeadersOnly", bHeadersOnly);
    }

    public boolean debugRequestHeadersOnly() {
        return this.getBoolean("debugRequestHeadersOnly");
    }

    public void setDebugRequest(boolean bDebug) {
        this.set("debugRequest", bDebug);
    }

    public boolean debugRequest() {
        return this.getBoolean("debugRequest");
    }

    public void removeRouteHost() {
        this.remove("routeHost");
    }

    public void setRouteHost(URL routeHost) {
        this.set("routeHost", routeHost);
    }

    public URL getRouteHost() {
        return (URL)this.get("routeHost");
    }

    public void addFilterExecutionSummary(String name, String status, long time) {
        StringBuilder sb = this.getFilterExecutionSummary();
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(name).append('[').append(status).append(']').append('[').append(time).append("ms]");
    }

    public StringBuilder getFilterExecutionSummary() {
        if (this.get("executedFilters") == null) {
            this.putIfAbsent("executedFilters", new StringBuilder());
        }
        return (StringBuilder)this.get("executedFilters");
    }

    public void setResponseBody(String body) {
        this.set("responseBody", body);
    }

    public String getResponseBody() {
        return (String)this.get("responseBody");
    }

    public void setResponseDataStream(InputStream responseDataStream) {
        this.set("responseDataStream", responseDataStream);
    }

    public void setResponseGZipped(boolean gzipped) {
        this.put("responseGZipped", gzipped);
    }

    public boolean getResponseGZipped() {
        return this.getBoolean("responseGZipped", true);
    }

    public InputStream getResponseDataStream() {
        return (InputStream)this.get("responseDataStream");
    }

    public boolean sendZuulResponse() {
        return this.getBoolean("sendZuulResponse", true);
    }

    public void setSendZuulResponse(boolean bSend) {
        this.set("sendZuulResponse", bSend);
    }

    public int getResponseStatusCode() {
        return this.get("responseStatusCode") != null ? (Integer)this.get("responseStatusCode") : 500;
    }

    public void setResponseStatusCode(int nStatusCode) {
        this.getResponse().setStatus(nStatusCode);
        this.set("responseStatusCode", nStatusCode);
    }

    public void addZuulRequestHeader(String name, String value) {
        this.getZuulRequestHeaders().put(name.toLowerCase(), value);
    }

    public Map<String, String> getZuulRequestHeaders() {
        if (this.get("zuulRequestHeaders") == null) {
            HashMap zuulRequestHeaders = new HashMap();
            this.putIfAbsent("zuulRequestHeaders", zuulRequestHeaders);
        }
        return (Map)this.get("zuulRequestHeaders");
    }

    public void addZuulResponseHeader(String name, String value) {
        this.getZuulResponseHeaders().add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public List<Pair<String, String>> getZuulResponseHeaders() {
        if (this.get("zuulResponseHeaders") == null) {
            ArrayList zuulRequestHeaders = new ArrayList();
            this.putIfAbsent("zuulResponseHeaders", zuulRequestHeaders);
        }
        return (List)this.get("zuulResponseHeaders");
    }

    public List<Pair<String, String>> getOriginResponseHeaders() {
        if (this.get("originResponseHeaders") == null) {
            ArrayList originResponseHeaders = new ArrayList();
            this.putIfAbsent("originResponseHeaders", originResponseHeaders);
        }
        return (List)this.get("originResponseHeaders");
    }

    public void addOriginResponseHeader(String name, String value) {
        this.getOriginResponseHeaders().add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public Integer getOriginContentLength() {
        return (Integer)this.get("originContentLength");
    }

    public void setOriginContentLength(Integer v) {
        this.set("originContentLength", v);
    }

    public void setOriginContentLength(String v) {
        try {
            Integer i = Integer.valueOf(v);
            this.set("originContentLength", i);
        }
        catch (NumberFormatException e) {
            LOG.warn("error parsing origin content length", (Throwable)e);
        }
    }

    public boolean isChunkedRequestBody() {
        Object v = this.get("chunkedRequestBody");
        return v != null ? (Boolean)v : false;
    }

    public void setChunkedRequestBody() {
        this.set("chunkedRequestBody", Boolean.TRUE);
    }

    public boolean isGzipRequested() {
        String requestEncoding = this.getRequest().getHeader("accept-encoding");
        return requestEncoding != null && requestEncoding.toLowerCase().contains("gzip");
    }

    public void unset() {
        threadLocal.remove();
    }

    public RequestContext copy() {
        RequestContext copy = new RequestContext();
        Iterator it = this.keySet().iterator();
        String key = (String)it.next();
        while (key != null) {
            Object orig = this.get(key);
            try {
                Object copyValue = DeepCopy.copy(orig);
                if (copyValue != null) {
                    copy.set(key, copyValue);
                } else {
                    copy.set(key, orig);
                }
            }
            catch (NotSerializableException e) {
                copy.set(key, orig);
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
        return copy;
    }

    public Map<String, List<String>> getRequestQueryParams() {
        return (Map)this.get("requestQueryParams");
    }

    public void setRequestQueryParams(Map<String, List<String>> qp) {
        this.put("requestQueryParams", qp);
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        HttpServletRequest request;
        @Mock
        HttpServletResponse response;

        @Test
        public void testGetContext() {
            RequestContext context = RequestContext.getCurrentContext();
            Assert.assertNotNull((Object)context);
        }

        @Test
        public void testSetContextVariable() {
            RequestContext context = RequestContext.getCurrentContext();
            Assert.assertNotNull((Object)context);
            context.set("test", "moo");
            Assert.assertEquals(context.get("test"), (Object)"moo");
        }

        @Test
        public void testSet() {
            RequestContext context = RequestContext.getCurrentContext();
            Assert.assertNotNull((Object)context);
            context.set("test");
            Assert.assertEquals(context.get("test"), (Object)Boolean.TRUE);
        }

        @Test
        public void testBoolean() {
            RequestContext context = RequestContext.getCurrentContext();
            Assert.assertEquals((Object)context.getBoolean("boolean_test"), (Object)Boolean.FALSE);
            Assert.assertEquals((Object)context.getBoolean("boolean_test", true), (Object)true);
        }

        @Test
        public void testCopy() {
            RequestContext context = RequestContext.getCurrentContext();
            context.put("test", "test");
            context.put("test1", "test1");
            context.put("test2", "test2");
            RequestContext copy = context.copy();
            Assert.assertEquals(copy.get("test"), (Object)"test");
            Assert.assertEquals(copy.get("test1"), (Object)"test1");
            Assert.assertEquals(copy.get("test2"), (Object)"test2");
        }

        @Test
        public void testResponseHeaders() {
            RequestContext context = RequestContext.getCurrentContext();
            context.addZuulRequestHeader("header", "test");
            Map<String, String> headerMap = context.getZuulRequestHeaders();
            Assert.assertNotNull(headerMap);
            Assert.assertEquals((Object)headerMap.get("header"), (Object)"test");
        }

        @Test
        public void testAccessors() {
            RequestContext context = new RequestContext();
            RequestContext.testSetCurrentContext(context);
            context.setRequest(this.request);
            context.setResponse(this.response);
            Throwable th = new Throwable();
            context.setThrowable(th);
            Assert.assertEquals((Object)context.getThrowable(), (Object)th);
            Assert.assertEquals((Object)context.debugRouting(), (Object)false);
            context.setDebugRouting(true);
            Assert.assertEquals((Object)context.debugRouting(), (Object)true);
            Assert.assertEquals((Object)context.debugRequest(), (Object)false);
            context.setDebugRequest(true);
            Assert.assertEquals((Object)context.debugRequest(), (Object)true);
            context.setDebugRequest(false);
            Assert.assertEquals((Object)context.debugRequest(), (Object)false);
            context.setDebugRouting(false);
            Assert.assertEquals((Object)context.debugRouting(), (Object)false);
            try {
                URL url = new URL("http://www.moldfarm.com");
                context.setRouteHost(url);
                Assert.assertEquals((Object)context.getRouteHost(), (Object)url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            InputStream in = (InputStream)Mockito.mock(InputStream.class);
            context.setResponseDataStream(in);
            Assert.assertEquals((Object)context.getResponseDataStream(), (Object)in);
            Assert.assertEquals((Object)context.sendZuulResponse(), (Object)true);
            context.setSendZuulResponse(false);
            Assert.assertEquals((Object)context.sendZuulResponse(), (Object)false);
            context.setResponseStatusCode(100);
            Assert.assertEquals((long)context.getResponseStatusCode(), (long)100L);
        }
    }
}

