/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.http;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.ServletInputStreamWrapper;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private static final HashMap<String, String[]> EMPTY_MAP = new HashMap();
    protected static final Logger LOG = LoggerFactory.getLogger(HttpServletRequestWrapper.class);
    private HttpServletRequest req;
    private byte[] contentData;
    private HashMap<String, String[]> parameters;

    public HttpServletRequestWrapper() {
        throw new IllegalArgumentException("Please use HttpServletRequestWrapper(HttpServletRequest request) constructor!");
    }

    private HttpServletRequestWrapper(HttpServletRequest request, byte[] contentData, HashMap<String, String[]> parameters) {
        this.req = request;
        this.contentData = contentData;
        this.parameters = parameters;
    }

    public HttpServletRequestWrapper(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("The HttpServletRequest is null!");
        }
        this.req = request;
    }

    public HttpServletRequest getRequest() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return new HttpServletRequestWrapper(this.req, this.contentData, this.parameters);
    }

    public byte[] getContentData() {
        return (byte[])this.contentData.clone();
    }

    public HashMap<String, String[]> getParameters() {
        if (this.parameters == null) {
            return EMPTY_MAP;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(this.parameters.size() * 2);
        for (String key : this.parameters.keySet()) {
            map.put(key, (String[])this.parameters.get(key).clone());
        }
        return map;
    }

    private void parseRequest() throws IOException {
        LinkedList<String> list;
        if (this.parameters != null) {
            return;
        }
        HashMap<String, LinkedList<String>> mapA = new HashMap<String, LinkedList<String>>();
        Map<String, List<String>> query = HTTPRequestUtils.getInstance().getQueryParams();
        if (query != null) {
            for (String key : query.keySet()) {
                list = query.get(key);
                mapA.put(key, list);
            }
        }
        LOG.debug("Path = " + this.req.getPathInfo());
        LOG.debug("Transfer-Encoding = " + String.valueOf(this.req.getHeader("transfer-encoding")));
        LOG.debug("Content-Encoding = " + String.valueOf(this.req.getHeader("Content-Encoding")));
        LOG.debug("Content-Length header = " + this.req.getContentLength());
        if (this.req.getContentLength() > 0) {
            boolean decode;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)this.req.getInputStream(), (OutputStream)baos);
            this.contentData = baos.toByteArray();
            try {
                LOG.debug("Length of contentData byte array = " + this.contentData.length);
                if (this.req.getContentLength() != this.contentData.length) {
                    LOG.warn("Content-length different from byte array length! cl=" + this.req.getContentLength() + ", array=" + this.contentData.length);
                }
            }
            catch (Exception e) {
                LOG.error("Error checking if request body gzipped!", (Throwable)e);
            }
            String enc = this.req.getCharacterEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            String s = new String(this.contentData, enc);
            StringTokenizer st = new StringTokenizer(s, "&");
            boolean bl = decode = this.req.getContentType() != null && this.req.getContentType().equalsIgnoreCase("application/x-www-form-urlencoded");
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                int i = s.indexOf("=");
                if (i <= 0 || s.length() <= i + 1) continue;
                String name = s.substring(0, i);
                String value = s.substring(i + 1);
                if (decode) {
                    try {
                        name = URLDecoder.decode(name, "UTF-8");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((list = (List)mapA.get(name)) == null) {
                    list = new LinkedList<String>();
                    mapA.put(name, list);
                }
                list.add(value);
            }
        } else if (this.req.getContentLength() == -1) {
            String transferEncoding = this.req.getHeader("transfer-encoding");
            if (transferEncoding != null && transferEncoding.equals("chunked")) {
                RequestContext.getCurrentContext().setChunkedRequestBody();
                LOG.debug("Set flag that request body is chunked.");
            }
        } else {
            LOG.warn("Content-Length is neither greater than zero or -1. = " + this.req.getContentLength());
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(mapA.size() * 2);
        for (String key : mapA.keySet()) {
            list = (LinkedList<String>)mapA.get(key);
            map.put(key, list.toArray(new String[list.size()]));
        }
        this.parameters = map;
    }

    public ServletInputStream getInputStream() throws IOException {
        this.parseRequest();
        if (RequestContext.getCurrentContext().isChunkedRequestBody()) {
            return this.req.getInputStream();
        }
        return new ServletInputStreamWrapper(this.contentData);
    }

    public BufferedReader getReader() throws IOException {
        this.parseRequest();
        String enc = this.req.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.contentData), enc));
    }

    public String getParameter(String name) {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        if (this.parameters == null) {
            return null;
        }
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map getParameterMap() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return this.getParameters();
    }

    public Enumeration getParameterNames() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return new Enumeration<String>(){
            private String[] arr;
            private int idx;
            {
                this.arr = HttpServletRequestWrapper.this.getParameters().keySet().toArray(new String[0]);
                this.idx = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.idx < this.arr.length;
            }

            @Override
            public String nextElement() {
                return this.arr[this.idx++];
            }
        };
    }

    public String[] getParameterValues(String name) {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        if (this.parameters == null) {
            return null;
        }
        String[] arr = this.parameters.get(name);
        if (arr == null) {
            return null;
        }
        return (String[])arr.clone();
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.req.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession() {
        return this.req.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.req.getSession(create);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public String getLocalAddr() {
        return this.req.getLocalAddr();
    }

    public String getLocalName() {
        return this.req.getLocalName();
    }

    public int getLocalPort() {
        return this.req.getLocalPort();
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getRealPath(String path) {
        return this.req.getRealPath(path);
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public int getRemotePort() {
        return this.req.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.req.getRequestDispatcher(path);
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.req.setAttribute(name, value);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(env);
    }

    public static final class UnitTest {
        @Mock
        HttpServletRequest request;

        @Before
        public void before() {
            RequestContext.getCurrentContext().unset();
            MockitoAnnotations.initMocks((Object)this);
            RequestContext.getCurrentContext().setRequest(this.request);
        }

        private void body(byte[] body) throws IOException {
            Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)new ServletInputStreamWrapper(body));
            Mockito.when((Object)this.request.getContentLength()).thenReturn((Object)body.length);
        }

        @Test
        public void handlesDuplicateParams() {
            Mockito.when((Object)this.request.getQueryString()).thenReturn((Object)"path=one&key1=val1&path=two");
            HttpServletRequestWrapper w = new HttpServletRequestWrapper(this.request);
            w.getParameterMap();
            HashMap<String, String[]> params = w.getParameters();
            Assert.assertFalse((String)"params should not be empty", (boolean)params.isEmpty());
            String[] paths = (String[])params.get("path");
            Assert.assertTrue((String)"paths param should not be empty", (paths.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"one", (Object)paths[0]);
            Assert.assertEquals((Object)"two", (Object)paths[1]);
        }

        @Test
        public void handlesPlainRequestBody() throws IOException {
            String body = "hello";
            this.body("hello".getBytes());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)wrapper.getInputStream()));
        }

        @Test
        public void handlesGzipRequestBody() throws IOException {
            String body = "hello";
            byte[] bodyBytes = "hello".getBytes();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(0);
            GZIPOutputStream gzipOutStream = new GZIPOutputStream(byteOutStream);
            gzipOutStream.write(bodyBytes);
            gzipOutStream.finish();
            gzipOutStream.flush();
            this.body(byteOutStream.toByteArray());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)new GZIPInputStream((InputStream)wrapper.getInputStream())));
        }

        @Test
        public void handlesZipRequestBody() throws IOException {
            String body = "hello";
            byte[] bodyBytes = "hello".getBytes();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(0);
            ZipOutputStream zOutput = new ZipOutputStream(byteOutStream);
            zOutput.putNextEntry(new ZipEntry("f1"));
            zOutput.write(bodyBytes);
            zOutput.finish();
            zOutput.flush();
            this.body(byteOutStream.toByteArray());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)this.readZipInputStream((InputStream)wrapper.getInputStream()));
        }

        public String readZipInputStream(InputStream input) throws IOException {
            byte[] uploadedBytes = this.getBytesFromInputStream(input);
            input.close();
            String uploadFileTxt = null;
            ZipInputStream zInput = new ZipInputStream(new ByteArrayInputStream(uploadedBytes));
            ZipEntry zipEntry = zInput.getNextEntry();
            if (zipEntry != null) {
                while (zipEntry != null) {
                    byte[] fileBytes = this.getBytesFromInputStream(zInput);
                    uploadFileTxt = new String(fileBytes);
                    zipEntry = zInput.getNextEntry();
                }
            }
            return uploadFileTxt;
        }

        private byte[] getBytesFromInputStream(InputStream input) throws IOException {
            int v = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((v = input.read()) != -1) {
                bos.write(v);
            }
            bos.close();
            return bos.toByteArray();
        }
    }
}

