/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.captcha;

import com.googlecode.aviator.AviatorEvaluator;
import com.pig4cloud.captcha.base.ArithmeticCaptchaAbstract;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class SimpleArithmeticCaptcha
extends ArithmeticCaptchaAbstract {
    public SimpleArithmeticCaptcha() {
    }

    public SimpleArithmeticCaptcha(int width, int height) {
        this();
        this.setWidth(width);
        this.setHeight(height);
    }

    public SimpleArithmeticCaptcha(int width, int height, int len) {
        this(width, height);
        this.setLen(len);
    }

    public SimpleArithmeticCaptcha(int width, int height, int len, Font font) {
        this(width, height, len);
        this.setFont(font);
    }

    public SimpleArithmeticCaptcha(int width, int height, int len, int font) throws IOException, FontFormatException {
        this(width, height, len);
        this.setFont(font, 32.0f);
    }

    @Override
    public boolean out(OutputStream out) {
        this.checkAlpha();
        return this.graphicsImage(this.getArithmeticString().toCharArray(), out);
    }

    @Override
    public String toBase64() {
        return this.toBase64("data:image/png;base64,");
    }

    @Override
    public String getContentType() {
        return "image/png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean graphicsImage(char[] strs, OutputStream out) {
        try {
            BufferedImage bi = new BufferedImage(this.width, this.height, 1);
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, this.width, this.height);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawOval(2, g2d);
            g2d.setFont(this.getFont());
            FontMetrics fontMetrics = g2d.getFontMetrics();
            int fW = this.width / strs.length;
            int fSp = (fW - (int)fontMetrics.getStringBounds("8", g2d).getWidth()) / 2;
            for (int i = 0; i < strs.length; ++i) {
                g2d.setColor(this.color());
                int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(strs[i]), g2d).getHeight() >> 1);
                g2d.drawString(String.valueOf(strs[i]), i * fW + fSp + 3, fY - 3);
            }
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", out);
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected char[] alphas() {
        int type;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.len - 1; ++i) {
            sb.append(SimpleArithmeticCaptcha.num(difficulty));
            if (i >= this.len - 1) continue;
            type = SimpleArithmeticCaptcha.num(1, 3);
            if (type == 1) {
                sb.append("+");
                continue;
            }
            if (type != 2) continue;
            sb.append("-");
        }
        this.chars = String.valueOf(AviatorEvaluator.execute((String)sb.toString()));
        int parseInt = Integer.parseInt(this.chars);
        if (parseInt < 0) {
            sb.append("+");
            sb.append(SimpleArithmeticCaptcha.num(-parseInt, -parseInt + 11));
        } else {
            type = SimpleArithmeticCaptcha.num(1, 3);
            if (type == 1) {
                sb.append("+");
                sb.append(SimpleArithmeticCaptcha.num(difficulty));
            } else if (type == 2) {
                sb.append("-");
                sb.append(SimpleArithmeticCaptcha.num(0, parseInt + 1));
            }
        }
        this.chars = String.valueOf(AviatorEvaluator.execute((String)sb.toString()));
        sb.append("=?");
        this.setArithmeticString(sb.toString());
        return this.chars.toCharArray();
    }
}

