/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.captcha;

import com.pig4cloud.captcha.base.ArithmeticCaptchaAbstract;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ArithmeticCaptcha
extends ArithmeticCaptchaAbstract {
    public ArithmeticCaptcha() {
    }

    public ArithmeticCaptcha(int width, int height) {
        this();
        this.setWidth(width);
        this.setHeight(height);
    }

    public ArithmeticCaptcha(int width, int height, int len) {
        this(width, height);
        this.setLen(len);
    }

    public ArithmeticCaptcha(int width, int height, int len, Font font) {
        this(width, height, len);
        this.setFont(font);
    }

    @Override
    public boolean out(OutputStream out) {
        this.checkAlpha();
        return this.graphicsImage(this.getArithmeticString().toCharArray(), out);
    }

    @Override
    public String toBase64() {
        return this.toBase64("data:image/png;base64,");
    }

    @Override
    public String getContentType() {
        return "image/png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean graphicsImage(char[] strs, OutputStream out) {
        BufferedImage bi = null;
        try {
            bi = new BufferedImage(this.width, this.height, 1);
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, this.width, this.height);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawOval(2, g2d);
            g2d.setFont(this.getFont());
            FontMetrics fontMetrics = g2d.getFontMetrics();
            int fW = this.width / strs.length;
            int fSp = (fW - (int)fontMetrics.getStringBounds("8", g2d).getWidth()) / 2;
            for (int i = 0; i < strs.length; ++i) {
                g2d.setColor(this.color());
                int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(strs[i]), g2d).getHeight() >> 1);
                g2d.drawString(String.valueOf(strs[i]), i * fW + fSp + 3, fY - 3);
            }
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", out);
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bi != null) {
                bi.getGraphics().dispose();
            }
        }
        return false;
    }
}

