/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.impl.dm;

import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoAggrMapper;
import com.pig4cloud.plugin.impl.dm.DmAbstractMapper;
import java.util.List;

public class ConfigInfoAggrMapperByDm
extends DmAbstractMapper
implements ConfigInfoAggrMapper {
    public String batchRemoveAggr(List<String> datumList) {
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append('\'').append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        return "DELETE FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND (tenant_id = ? OR tenant_id IS NULL) AND datum_id IN (" + datumString + ")";
    }

    public String aggrConfigInfoCount(int size, boolean isIn) {
        StringBuilder sql = new StringBuilder("SELECT count(*) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND (tenant_id = ? OR tenant_id IS NULL) AND datum_id");
        if (isIn) {
            sql.append(" IN (");
        } else {
            sql.append(" NOT IN (");
        }
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(')');
        return sql.toString();
    }

    public String findConfigInfoAggrIsOrdered() {
        return "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND (tenant_id = ? OR tenant_id IS NULL) ORDER BY datum_id";
    }

    public String findConfigInfoAggrByPageFetchRows(int startRow, int pageSize) {
        String sql = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id= ? AND group_id= ? AND (tenant_id= ? OR tenant_id IS NULL) ORDER BY datum_id";
        return this.buildPaginationSql(sql, startRow, pageSize);
    }

    public String findAllAggrGroupByDistinct() {
        return "SELECT DISTINCT data_id, group_id, tenant_id FROM config_info_aggr";
    }

    @Override
    public String getTableName() {
        return "config_info_aggr";
    }

    @Override
    public String getDataSource() {
        return "dameng";
    }
}

