/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.impl.dm;

import com.alibaba.nacos.plugin.datasource.mapper.AbstractMapper;
import java.util.List;

public abstract class DmAbstractMapper
extends AbstractMapper {
    public String select(List<String> columns, List<String> where) {
        int i;
        StringBuilder sql = new StringBuilder("SELECT ");
        for (i = 0; i < columns.size(); ++i) {
            sql.append(columns.get(i));
            if (i == columns.size() - 1) {
                sql.append(" ");
                continue;
            }
            sql.append(",");
        }
        sql.append("FROM ");
        sql.append(this.getTableName());
        sql.append(" ");
        if (where.size() == 0) {
            return sql.toString();
        }
        sql.append("WHERE ");
        for (i = 0; i < where.size(); ++i) {
            String column = where.get(i);
            if ("tenant_id".equalsIgnoreCase(column)) {
                sql.append("(");
                sql.append(column).append(" = ").append("?");
                sql.append(" OR ");
                sql.append(column).append(" IS NULL ");
                sql.append(")");
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == where.size() - 1) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public String update(List<String> columns, List<String> where) {
        int i;
        StringBuilder sql = new StringBuilder();
        String method = "UPDATE ";
        sql.append(method);
        sql.append(this.getTableName()).append(" ").append("SET ");
        for (i = 0; i < columns.size(); ++i) {
            sql.append(columns.get(i)).append(" = ").append("?");
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        if (where.size() == 0) {
            return sql.toString();
        }
        sql.append(" WHERE ");
        for (i = 0; i < where.size(); ++i) {
            String column = where.get(i);
            if ("tenant_id".equalsIgnoreCase(column)) {
                sql.append("(");
                sql.append(column).append(" = ").append("?");
                sql.append(" OR ");
                sql.append(column).append(" IS NULL ");
                sql.append(")");
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == where.size() - 1) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public String delete(List<String> params) {
        StringBuilder sql = new StringBuilder();
        String method = "DELETE ";
        sql.append(method).append("FROM ").append(this.getTableName()).append(" ").append("WHERE ");
        for (int i = 0; i < params.size(); ++i) {
            String column = params.get(i);
            if ("tenant_id".equalsIgnoreCase(column)) {
                sql.append("(");
                sql.append(column).append(" = ").append("?");
                sql.append(" OR ");
                sql.append(column).append(" IS NULL ");
                sql.append(")");
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == params.size() - 1) continue;
            sql.append("AND ");
        }
        return sql.toString();
    }

    public String count(List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append("COUNT(*) FROM ");
        sql.append(this.getTableName());
        sql.append(" ");
        if (null == where || where.size() == 0) {
            return sql.toString();
        }
        sql.append("WHERE ");
        for (int i = 0; i < where.size(); ++i) {
            String column = where.get(i);
            if ("tenant_id".equalsIgnoreCase(column)) {
                sql.append("(");
                sql.append(column).append(" = ").append("?");
                sql.append(" OR ");
                sql.append(column).append(" IS NULL ");
                sql.append(")");
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == where.size() - 1) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public String buildPaginationSql(String originalSql, int startRow, int pageSize) {
        return "SELECT * FROM ( SELECT TMP2.* FROM (SELECT TMP.*, ROWNUM ROW_ID FROM ( " + originalSql + " ) TMP) TMP2 WHERE ROWNUM <=" + (startRow + pageSize) + ") WHERE ROW_ID > " + startRow;
    }

    public abstract String getTableName();

    public abstract String getDataSource();
}

