/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp;

import com.seeyon.cdp.CDPEmbeddedConnector;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.config.ConfigDeliver;
import org.apache.commons.logging.Log;

public class CDPAgent {
    private static final Log LOG = CtpLogFactory.getLog(CDPAgent.class);

    public static final void configure(String password) {
        if (CDPAgent.isEnabled()) {
            SystemProperties properties = SystemProperties.getInstance();
            String schema = properties.getProperty("cdp.service.schema");
            String host = properties.getProperty("cdp.service.host");
            String port = properties.getProperty("cdp.service.port");
            new ConfigDeliver(schema, host, port).push(password);
        } else {
            LOG.debug((Object)"CDP\u672a\u542f\u7528\uff0c\u5ffd\u7565\u6570\u636e\u53d1\u9001\u3002");
        }
    }

    public static final boolean isEnabled() {
        if (!SystemEnvironment.hasPlugin("cdp")) {
            return false;
        }
        boolean isEnabled = "true".equals(SystemProperties.getInstance().getProperty("cdp.enabled"));
        return isEnabled;
    }

    public static CDPEmbeddedConnector getConnectorInstance() {
        return ConnectorHolder.INSTANCE;
    }

    private static class ConnectorHolder {
        private static final CDPEmbeddedConnector INSTANCE = new CDPEmbeddedConnector();

        private ConnectorHolder() {
        }
    }
}

