/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp;

import com.seeyon.cdp.Sender;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.springframework.web.client.ResourceAccessException;

class Queue {
    private static final Log LOG = CtpLogFactory.getLog(Queue.class);
    private BlockingQueue<HashMap> queue = new LinkedBlockingQueue<HashMap>(100000);
    private static Queue instance = new Queue();
    private final DispatchThread dispatchThread = new DispatchThread();

    private Queue() {
    }

    public static Queue getInstance() {
        return instance;
    }

    public void start() {
        this.dispatchThread.start();
    }

    public void stop() {
        try {
            this.dispatchThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispatchThread.running = false;
    }

    public boolean add(HashMap data) {
        if (this.dispatchThread.running) {
            try {
                return this.queue.offer(data, 100L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    class DispatchThread
    extends Thread {
        private Sender sender = new Sender();
        private boolean isConnected = false;
        private long lastSuccessTime = System.currentTimeMillis();
        boolean running = true;

        public DispatchThread() {
            super.setName("CDPDispatchThread");
        }

        @Override
        public synchronized void start() {
            super.start();
            LOG.info((Object)"CDP\u4efb\u52a1\u5b88\u62a4\u8fdb\u7a0b\u542f\u52a8");
        }

        @Override
        public void run() {
            while (this.running) {
                int i;
                int count = 0;
                StopWatch watch = new StopWatch();
                watch.start();
                for (i = 11; i > 1 && !Queue.this.queue.isEmpty(); --i) {
                    count += this.send(1000);
                }
                watch.stop();
                LOG.info((Object)("\u53d1\u9001" + count + "\u6761\uff0c\u8017\u65f6" + watch.getTime()));
                long millis = (long)i * 1000L;
                try {
                    Thread.sleep(millis);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }

        private int send(int batchSize) {
            try {
                HashMap item;
                ArrayList<HashMap> list = new ArrayList<HashMap>(batchSize);
                int i = batchSize;
                while (i-- > 0 && (item = (HashMap)Queue.this.queue.poll()) != null) {
                    list.add(item);
                }
                this.sender.send(list);
                this.lastSuccessTime = System.currentTimeMillis();
                this.isConnected = true;
                return list.size();
            }
            catch (Exception e) {
                if (e instanceof ResourceAccessException) {
                    this.isConnected = false;
                }
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return 0;
            }
        }
    }
}

