/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp.rule;

import com.seeyon.cdp.rule.Context;
import com.seeyon.cdp.rule.Execution;
import com.seeyon.cdp.rule.Rule;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RuleExecuteThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(RuleExecuteThread.class);
    private Rule rule;
    private Context ctx;
    private List<Execution> executions;

    public RuleExecuteThread(Rule rule, Context ctx, List<Execution> executions) {
        this.rule = rule;
        this.ctx = ctx;
        this.executions = executions;
    }

    @Override
    public void run() {
        try {
            if (this.rule.accept(this.ctx)) {
                for (Execution e : this.executions) {
                    try {
                        e.execute(this.ctx);
                    }
                    catch (BusinessException e1) {
                        LOG.error((Object)("\u89c4\u5219" + e.toString() + "\u6267\u884c\u51fa\u9519\uff1a" + e1.getLocalizedMessage()), (Throwable)e1);
                    }
                }
            } else {
                LOG.debug((Object)("\u89c4\u5219\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8df3\u8fc7\uff1a" + this.rule + " " + this.ctx));
            }
        }
        catch (BusinessException e) {
            LOG.error((Object)(e.getLocalizedMessage() + this.rule + " " + this.ctx + " "), (Throwable)e);
        }
    }
}

