/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.NodeInfo;
import com.seeyon.ctp.cluster.NodeManager;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ServerDetector;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class ClusterConfigBean {
    private static final Log log = CtpLogFactory.getLog("com.seeyon.ctp.ClusterConfigBean");
    private static ClusterConfigBean bean;
    private boolean clusterEnabled;
    private boolean clusterMain;
    private String clusterName;
    private String clusterHostIndex;
    private String hosts;
    private String localhost;
    private String clusterMainHost;
    private int geodeLocatorPort = 9009;
    private int geodeServerPort = 9010;
    private String memeberPortRange = "9011-9013";
    private boolean geodeLocatorOn = true;
    private String clusterMainHostPort;
    private boolean geodeEnabled = false;
    private NodeManager nodeManager = null;

    public Collection<URL> getClusterUrls() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Strings.isNotEmpty(this.hosts)) {
            String[] arr;
            for (String ip : arr = this.hosts.split(",")) {
                NodeInfo nodeInfo;
                String index = ip.substring(ip.lastIndexOf(46) + 1);
                if (!this.isAlive(index) || (nodeInfo = this.nodeManager.getNodeInfo(index)) == null) continue;
                urls.add(new URL("http", ip, Integer.parseInt(nodeInfo.getPort()), ""));
            }
        }
        return urls;
    }

    private ClusterConfigBean() {
    }

    public static ClusterConfigBean getInstance() {
        if (bean == null) {
            bean = new ClusterConfigBean();
            bean.init();
        }
        return bean;
    }

    public boolean isAlive(String node) {
        if (this.nodeManager == null) {
            return false;
        }
        return this.nodeManager.isAlive(node);
    }

    public Long getStartTime(String node) {
        if (this.nodeManager == null) {
            return null;
        }
        return this.nodeManager.getStartTime(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String memberPortRange;
        String serverPort;
        String clusterMainHostPort2;
        String f0 = File.separator;
        String parent = ".." + f0;
        String clusterFilepath = SystemEnvironment.getApplicationFolder() + f0 + parent + parent + parent + "base" + f0 + "conf" + f0 + "cluster.properties";
        File f = new File(clusterFilepath);
        Properties clusterProps = new Properties();
        if (f.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                clusterProps.load(in);
            }
            catch (Exception e) {
                log.error((Object)("\u52a0\u8f7d\u96c6\u7fa4\u914d\u7f6e\u6587\u4ef6[" + clusterFilepath + "]\u5f02\u5e38"), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        this.clusterEnabled = Boolean.parseBoolean((String)clusterProps.get("cluster.enabled"));
        this.clusterMain = Boolean.parseBoolean((String)clusterProps.get("cluster.main"));
        this.clusterName = (String)clusterProps.get("cluster.name");
        this.clusterHostIndex = clusterProps.getProperty("cluster.host.index", "");
        this.hosts = (String)clusterProps.get("cluster.hosts");
        this.localhost = (String)clusterProps.get("cluster.localhost");
        if (this.localhost == null) {
            this.localhost = System.getProperty("jgroups.bind_addr");
        }
        if ((clusterMainHostPort2 = (String)clusterProps.get("cluster.port")) == null) {
            clusterMainHostPort2 = System.getProperty("cluster.port");
        }
        if (Strings.isEmpty(clusterMainHostPort2)) {
            clusterMainHostPort2 = ServerDetector.isWebLogic() ? "7003" : (ServerDetector.isWebSphere() ? "9080" : "80");
        }
        this.setClusterMainHostPort(clusterMainHostPort2);
        String locatorPort = (String)clusterProps.get("cluster.geode.locator.port");
        if (!Strings.isEmpty(locatorPort)) {
            try {
                this.setGeodeLocatorPort(Integer.parseInt(locatorPort));
            }
            catch (Exception e) {
                log.error((Object)"\u4ececluster.properties\u6587\u4ef6\u4e2d\u52a0\u8f7dclusterGeodePort\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        if (!Strings.isEmpty(serverPort = clusterProps.getProperty("cluster.geode.server.port"))) {
            try {
                this.setGeodeServerPort(Integer.parseInt(serverPort));
            }
            catch (Exception e) {
                log.error((Object)"\u4ececluster.properties\u6587\u4ef6\u4e2d\u52a0\u8f7dclusterGeodePort\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        if (!Strings.isEmpty(memberPortRange = clusterProps.getProperty("cluster.geode.member.port.range"))) {
            try {
                this.setMemeberPortRange(memberPortRange);
            }
            catch (Exception e) {
                log.error((Object)"\u4ececluster.properties\u6587\u4ef6\u4e2d\u52a0\u8f7dmemberPortRange\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        if ("off".equals(System.getProperty("cluster.geode.locator.on"))) {
            this.geodeLocatorOn = false;
        }
        if (this.clusterMain) {
            this.setClusterMainHost(this.localhost);
        }
        if (this.clusterEnabled) {
            if (this.clusterName == null || "".equals(this.clusterName) || this.clusterHostIndex == null || "".equals(this.clusterHostIndex)) {
                System.out.println("**************************************************************************");
                System.out.println("");
                System.out.println("Exception,Error \uff1a \u542f\u52a8\u96c6\u7fa4/\u53cc\u673a\u5931\u8d25, \u8bf7\u5728\u5e94\u7528\u914d\u7f6e\u5668\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570: " + this.toString());
                System.out.println("");
                System.out.println("**************************************************************************");
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(-1);
            } else {
                log.info((Object)("\u52a0\u8f7d\u96c6\u7fa4/\u53cc\u673a\u914d\u7f6e\u6587\u4ef6: " + this.toString()));
                this.geodeEnabled = this.clusterEnabled && !"true".equals(System.getProperty("cluster.geode.disable")) && System.getProperty("java.version").compareTo("1.8") >= 0;
            }
            this.nodeManager = new NodeManager();
            this.nodeManager.init(this.clusterHostIndex);
        } else {
            log.info((Object)"\u96c6\u7fa4/\u53cc\u673a\u672a\u542f\u7528");
        }
    }

    public boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    public boolean isGeodeEnabled() {
        return this.geodeEnabled;
    }

    public boolean isClusterMain() {
        return this.clusterMain;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterHostIndex() {
        return this.clusterHostIndex;
    }

    public String toString() {
        return this.clusterName + ", " + (this.clusterMain ? "\u4e3b" : "\u4ece") + ", " + this.clusterHostIndex;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public String getClusterMainHost() {
        return this.clusterMainHost;
    }

    public void setClusterMainHost(String clusterMainHost) {
        this.clusterMainHost = clusterMainHost;
    }

    public String getClusterMainHostPort() {
        return this.clusterMainHostPort;
    }

    public void setClusterMainHostPort(String clusterMainHostPort) {
        this.clusterMainHostPort = clusterMainHostPort;
    }

    public void setGeodeLocatorPort(int port) {
        this.geodeLocatorPort = port;
    }

    public int getGeodeLocatorPort() {
        return this.geodeLocatorPort;
    }

    public void setGeodeServerPort(int port) {
        this.geodeServerPort = port;
    }

    public String getMemeberPortRange() {
        return this.memeberPortRange;
    }

    public void setMemeberPortRange(String memeberPortRange) {
        this.memeberPortRange = memeberPortRange;
    }

    public int getGeodeServerPort() {
        return this.geodeServerPort;
    }

    public boolean isGeodeLocatorOn() {
        return this.geodeLocatorOn;
    }
}

