/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster.adapter.jgroups;

import com.seeyon.ctp.cluster.adapter.jgroups.AbstractCNotificationService;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotification;
import com.seeyon.ctp.cluster.adapter.jgroups.ICNotificationHandler;
import com.seeyon.ctp.cluster.adapter.jgroups.JChannelLoader;
import com.seeyon.ctp.cluster.event.SlaveStatusEvent;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.event.EventDispatcher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

class CNotificationServiceImpl
extends AbstractCNotificationService {
    private static final Log logger = LogFactory.getLog(CNotificationServiceImpl.class);
    public JChannel jgroupsChannel = null;
    private long cooldown = 0L;

    CNotificationServiceImpl() {
    }

    @Override
    public void init(String protocol) {
        URL url;
        logger.info((Object)("init jgroups channel:" + protocol));
        try {
            url = new File(AppContext.getCfgHome().getAbsolutePath() + "/cluster/" + protocol + "2.xml").toURL();
        }
        catch (MalformedURLException e1) {
            logger.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
            return;
        }
        if (this.jgroupsChannel != null) {
            this.jgroupsChannel.close();
        }
        this.jgroupsChannel = JChannelLoader.getJChannel(url);
        if (this.jgroupsChannel == null) {
            logger.error((Object)("channel is null:" + url));
        } else {
            ReceiveCallback recvCallback = new ReceiveCallback();
            this.jgroupsChannel.setReceiver((Receiver)recvCallback);
            this.jgroupsChannel.setDiscardOwnMessages(true);
            try {
                this.jgroupsChannel.connect(JChannelLoader.getClusterName());
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void sendCNotification(CNotification notification) {
        block4: {
            try {
                this.jgroupsChannel.send(null, (Object)notification);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                long now = System.currentTimeMillis();
                if (this.cooldown >= now) break block4;
                this.cooldown = now + 180000L;
                logger.info((Object)"\u8fde\u63a5\u51fa\u9519\uff0c\u5c1d\u8bd5\u91cd\u8fde");
                try {
                    this.jgroupsChannel.send(null, (Object)notification);
                }
                catch (Exception e1) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getLocalAddress() {
        if (this.jgroupsChannel == null) {
            return null;
        }
        return this.jgroupsChannel.getAddress().toString();
    }

    @Override
    public JChannel getChannel() {
        return this.jgroupsChannel;
    }

    private class ReceiveCallback
    extends ReceiverAdapter {
        private Address masterAddress;
        private boolean online = false;
        private Thread suicideThread;

        private ReceiveCallback() {
        }

        public void receive(Message msg) {
            CNotification notification;
            ICNotificationHandler handler;
            if (CNotificationServiceImpl.this.jgroupsChannel.getAddress().equals(msg.getSrc())) {
                return;
            }
            logger.debug((Object)("receive message from remote " + msg.getSrc()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("receive message " + msg.getObject()));
            }
            if ((handler = CNotificationServiceImpl.this.getHandler((notification = (CNotification)msg.getObject()).getType())) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("handle notification:" + notification.getType() + " " + handler));
                }
                handler.handler(notification);
            } else {
                logger.warn((Object)("\u6ca1\u6709\u6ce8\u518cHandler:" + notification.getType()));
            }
        }

        public void viewAccepted(View view) {
            if (this.masterAddress == null) {
                this.masterAddress = (Address)view.getMembers().get(0);
                this.online = true;
                this.initSuicideThread();
            } else if (view.getMembers().contains(this.masterAddress)) {
                this.online = true;
            } else {
                this.online = false;
                if ("on".equals(SystemProperties.getInstance().getProperty("cluster.slaveOffline.enable"))) {
                    logger.warn((Object)"************ \u4ece\u8282\u70b9\u6389\u7ebf ... \u542f\u52a8\u81ea\u6740\u4efb\u52a1 ***********");
                    if (!this.suicideThread.isAlive()) {
                        this.suicideThread.start();
                    }
                }
            }
        }

        private void initSuicideThread() {
            this.suicideThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.warn((Object)"************ \u81ea\u6740\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u7b49\u5f8530\u79d2\u68c0\u67e5\u8fde\u63a5\u662f\u5426\u4fee\u590d ***********");
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (ReceiveCallback.this.online) {
                        logger.warn((Object)"************ \u8fde\u63a5\u5df2\u4fee\u590d\uff0c\u81ea\u6740\u4efb\u52a1\u53d6\u6d88 ***********");
                        return;
                    }
                    logger.warn((Object)"************ \u81ea\u6740\u4efb\u52a1\u901a\u77e5\u76f8\u5173\u7528\u6237\uff0c\u7b49\u5f8560\u79d2\u786e\u4fdd\u6b63\u5f0f\u53d1\u51fa\u901a\u77e5\u6d88\u606f ***********");
                    ReceiveCallback.this.notifySlaveStateChange(false);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (ReceiveCallback.this.online) {
                        logger.warn((Object)"************ \u8fde\u63a5\u5df2\u4fee\u590d\uff0c\u901a\u77e5\u76f8\u5173\u7528\u6237\u8fde\u63a5\u5df2\u81ea\u52a8\u4fee\u590d\uff0c\u81ea\u6740\u4efb\u52a1\u53d6\u6d88 ***********");
                        ReceiveCallback.this.notifySlaveStateChange(true);
                    } else {
                        logger.warn((Object)"************ \u786e\u8ba4\u4ece\u8282\u70b9\u5df2\u7ecf\u5b8c\u5168\u6389\u7ebf\uff0c\u81ea\u6740\u4efb\u52a1\u505c\u6b62\u670d\u52a1... **********");
                        System.exit(-1);
                    }
                }
            });
        }

        private void notifySlaveStateChange(boolean online) {
            SlaveStatusEvent ssEvent = new SlaveStatusEvent((Object)this);
            ssEvent.setOnline(online);
            EventDispatcher.fireEvent(ssEvent);
        }
    }
}

