/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.RunInRightEvent;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.SystemInitializer;
import com.seeyon.ctp.common.cache.GenericTimeRing;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.dao.HibernateQueryPlanCacheUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.common.quartz.QuartzJob;
import com.seeyon.ctp.common.safetyprotection.manager.SafetyProtectionLogManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class RunInRightEventHolder
implements QuartzJob,
SystemInitializer {
    private static Log log = CtpLogFactory.getLog(RunInRightEventHolder.class);
    private List<RunInRightEvent> runInRightEvents;
    private static SafetyProtectionLogManager safetyProtectionLogManager;

    public void init() throws Exception {
    }

    @Override
    public void initialize() {
        Date runTime = Datetimes.addMinute(Datetimes.getTodayLastTime(), 31);
        try {
            QuartzHolder.deleteQuartzJob("RunInRightEventHolder");
            QuartzHolder.newQuartzJobPerDay(null, "RunInRightEventHolder", runTime, "RunInRightEventHolder", null);
            log.info((Object)("\u521b\u5efaRunInRightEventHolder\uff1a" + runTime));
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        this.runInRightEvents = new ArrayList<RunInRightEvent>(AppContext.getBeansOfType(RunInRightEvent.class).values());
        log.info((Object)("\u52a0\u8f7dRunInRightEvent\uff1a" + this.runInRightEvents.size()));
    }

    @Override
    public void destroy() {
    }

    @Override
    public void execute(Map<String, String> parameters) {
        log.info((Object)"\u5f00\u59cb\u6267\u884cRunInRightEvents......");
        if (!Strings.isEmpty(this.runInRightEvents)) {
            for (RunInRightEvent runInRightEvent : this.runInRightEvents) {
                try {
                    log.info((Object)("\u5f00\u59cb\u6267\u884cRunInRightEvent: " + runInRightEvent));
                    runInRightEvent.run();
                    log.info((Object)("\u6267\u884c\u5b8c\u6210RunInRightEvent: " + runInRightEvent));
                }
                catch (Throwable e) {
                    log.error((Object)("\u6267\u884cRunInRightEvent\u5f02\u5e38: " + runInRightEvent), e);
                }
            }
        }
        this.run();
    }

    public void run() {
        RunInRightEventHolder.gc();
        try {
            this.cleanLogs();
            RunInRightEventHolder.clearTemporary();
            RunInRightEventHolder.ceartPrintPdf();
        }
        catch (Throwable e) {
            log.error((Object)"", e);
        }
        if (!SystemEnvironment.isDistributedMode() || SystemEnvironment.isBaseService()) {
            try {
                RunInRightEventHolder.getSafetyProtectionLogManager().deleteLogs();
            }
            catch (Throwable e) {
                log.error((Object)"", e);
            }
        }
        RunInRightEventHolder.gc();
        HibernateQueryPlanCacheUtil.clearInitQueryPlanCache();
        GenericTimeRing.clearAll();
    }

    private static void clearTemporary() {
        File tempFolder = new File(SystemEnvironment.getSystemTempFolder());
        log.info((Object)("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5939\u5f00\u59cb[" + tempFolder + "]..."));
        if (!tempFolder.exists() || !tempFolder.isDirectory()) {
            return;
        }
        int count = RunInRightEventHolder.clearTemporaryFile(tempFolder);
        log.info((Object)("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5939\u5b8c\u6210\uff0c\u5171\u6e05\u7406\u6587\u4ef6\u6570\uff1a" + count));
    }

    private static void ceartPrintPdf() {
        File pdfFolder = new File(SystemEnvironment.getApplicationFolder() + File.separator + "print" + File.separator + "web");
        File toolFolder = System.getProperty("os.name").indexOf("Windows") == -1 ? new File(SystemEnvironment.getApplicationFolder() + File.separator + "print" + File.separator + "tools" + File.separator + "linux") : new File(SystemEnvironment.getApplicationFolder() + File.separator + "print" + File.separator + "tools" + File.separator + "windows");
        log.info((Object)("\u6e05\u7406\u6253\u5370\u4e34\u65f6\u6587\u4ef6[" + pdfFolder + "]..."));
        if (!pdfFolder.exists() || !pdfFolder.isDirectory()) {
            return;
        }
        int count = RunInRightEventHolder.clearPrintFile(pdfFolder);
        if (!toolFolder.exists() || !toolFolder.isDirectory()) {
            return;
        }
        int toolcount = RunInRightEventHolder.clearPrintFile(toolFolder);
        log.info((Object)("\u6e05\u7406\u6253\u5370\u4e34\u65f6\u6587\u4ef6\u5b8c\u6210\uff0c\u5171\u6e05\u7406\u6587\u4ef6\u6570\uff1a" + (count + toolcount)));
    }

    private static int clearPrintFile(File folder) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            String fileName;
            String suffix;
            File file = files[i];
            if (!file.isFile() || !"pdf".equals(suffix = (fileName = file.getName()).substring(fileName.lastIndexOf(".") + 1)) && !"bat".equals(suffix) && !"sh".equals(suffix) && !"txt".equals(suffix)) continue;
            file.delete();
            ++count;
        }
        return count;
    }

    private static int clearTemporaryFile(File folder) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                if (System.currentTimeMillis() - file.lastModified() <= 10800000L) continue;
                file.delete();
                ++count;
                continue;
            }
            if (!file.isDirectory()) continue;
            RunInRightEventHolder.clearTemporaryFile(file);
        }
        return count;
    }

    private static void gc() {
        try {
            Runtime rt = Runtime.getRuntime();
            long currentUsedMemory0 = rt.totalMemory() - rt.freeMemory();
            System.gc();
            long currentUsedMemory1 = rt.totalMemory() - rt.freeMemory();
            log.info((Object)("System.gc() : " + Strings.formatFileSize(currentUsedMemory0 - currentUsedMemory1, false)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanLogs() {
        File[] dayDirs1;
        String logs;
        File outputDir1;
        File[] dayDirs;
        log.info((Object)"\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u5939\u5f00\u59cb");
        int period = -SystemProperties.getInstance().getIntegerProperty("logClean.period", 90).intValue();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, period);
        Date datebefore = calendar.getTime();
        String logs_sy = SystemEnvironment.getLogsFolder();
        File outputDir = new File(logs_sy);
        if (outputDir != null && (dayDirs = outputDir.listFiles()) != null) {
            for (File dayDir : dayDirs) {
                try {
                    Date date1;
                    if (!dayDir.isDirectory() || dayDir.getName().length() != 10 || !(date1 = Datetimes.parse(dayDir.getName(), "yyyy-MM-dd")).before(datebefore)) continue;
                    FileUtils.deleteDirectory((File)dayDir);
                }
                catch (Throwable e) {
                    log.error((Object)"\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u62a5\u9519\uff1a> ", e);
                }
            }
        }
        if ((outputDir1 = new File(logs = SystemEnvironment.getApplicationFolder() + "/../../logs/")) != null && (dayDirs1 = outputDir1.listFiles()) != null) {
            for (File dayDir : dayDirs1) {
                try {
                    Date date1;
                    String[] names;
                    if (!dayDir.isFile() || (names = dayDir.getName().split("[.]")).length != 3 || !(date1 = Datetimes.parse(names[1], "yyyy-MM-dd")).before(datebefore)) continue;
                    FileUtils.deleteQuietly((File)dayDir);
                }
                catch (Throwable e) {
                    log.error((Object)"\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u62a5\u9519\uff1a> ", e);
                }
            }
        }
        log.info((Object)"\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u5939\u7ed3\u675f");
    }

    private static SafetyProtectionLogManager getSafetyProtectionLogManager() {
        if (safetyProtectionLogManager == null) {
            safetyProtectionLogManager = (SafetyProtectionLogManager)AppContext.getBean("safetyProtectionLogManager");
        }
        return safetyProtectionLogManager;
    }
}

