/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.login.online.OnlineManager;
import com.seeyon.ctp.session.CTPSessionRepository;
import com.seeyon.ctp.util.ServerDetector;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;

public class ServerState {
    private static final Log log = CtpLogFactory.getLog(ServerState.class);
    private static final long DELAY = 15000L;
    private static final long PERIOD = 15000L;
    private static final int MINMINUTE = 1;
    private static int autoExitdelay = 30;
    private static ServerState instance;
    private static OnlineManager onLineManager;
    private State currentState = State.normalization;
    private long currentTime = 0L;
    private long second = 0L;
    private String comment;
    private long stopwatch = 0L;
    private boolean autoExit;
    private Timer timer;
    private Map<Long, Boolean> hasWarnUsers = new HashMap<Long, Boolean>();

    private ServerState() {
    }

    public static ServerState getInstance() {
        if (instance == null) {
            instance = new ServerState();
            onLineManager = (OnlineManager)AppContext.getBean("onlineManager");
        }
        return instance;
    }

    public void setStateShutdown(int minute, String comment, boolean _autoExit) {
        int minute2 = minute;
        NotificationManager.getInstance().send(NotificationType.ServerStateShutdown, new Object[]{minute2, comment, _autoExit});
        this.autoExit = _autoExit;
        minute2 = Math.max(minute2, 1);
        this.second = this.stopwatch = (long)(minute2 * 60) * 1000L;
        this.currentState = State.shutdown;
        this.comment = comment;
        this.currentTime = System.currentTimeMillis();
        autoExitdelay = Integer.parseInt(SystemProperties.getInstance().getProperty("message.interval.second")) * 2 + 15;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (ServerState.this.stopwatch > 0L) {
                    System.out.println("[\u63d0\u9192] : \u505c\u6b62\u670d\u52a1\u5012\u8ba1\u65f6 " + ServerState.this.stopwatch / 1000L + " \u79d2. \u5f53\u524d " + onLineManager.getOnlineNumber() + " \u4eba\u5728\u7ebf");
                    ServerState.this.stopwatch = ServerState.this.stopwatch - 15000L;
                } else {
                    ServerState.this.timer.cancel();
                    if (ServerState.this.autoExit) {
                        System.out.println("[\u63d0\u9192] : \u670d\u52a1\u505c\u6b62\u9884\u7559\u65f6\u95f4\u5230\uff0c\u670d\u52a1\u5668\u5728 " + autoExitdelay + " \u79d2\u949f\u540e\u81ea\u52a8\u5173\u95ed.");
                        CTPSessionRepository.shutdown();
                        for (int i = autoExitdelay; i > 0; --i) {
                            try {
                                Thread.sleep(1000L);
                                System.out.print(i - 1 + "  ");
                                continue;
                            }
                            catch (InterruptedException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        ServerState.this.toXiaoDiqiu();
                        if (ServerDetector.isTomcat()) {
                            System.exit(0);
                        }
                    } else {
                        System.out.println("[\u63d0\u9192] : \u670d\u52a1\u505c\u6b62\u9884\u7559\u65f6\u95f4\u5230");
                    }
                }
            }
        };
        this.stopwatch -= 15000L;
        this.timer = new Timer(true);
        this.timer.schedule(task, 15000L, 15000L);
        log.info((Object)("\u5c06\u670d\u52a1\u5668\u72b6\u6001\u8bbe\u7f6e\u4e3a\u201c\u505c\u6b62\u201d[" + minute2 + ", " + comment + ", " + _autoExit + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toXiaoDiqiu() {
        String path = SystemEnvironment.getApplicationFolder() + "/../../../service/starttomcat";
        path = Strings.getCanonicalPath(path);
        FileOutputStream out = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                return;
            }
            out = new FileOutputStream(file, false);
            out.write("StopTomcat".getBytes());
            out.flush();
        }
        catch (FileNotFoundException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public int getShutdownTime() {
        return (int)((this.second - (System.currentTimeMillis() - this.currentTime)) / 1000L);
    }

    public boolean isShutdown() {
        return State.shutdown.equals((Object)this.currentState);
    }

    public boolean isShutdownWarn(Long userId) {
        if (this.isShutdown() && !this.hasWarnUsers.containsKey(userId)) {
            this.hasWarnUsers.put(userId, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public boolean isForceLogout() {
        return this.isShutdown() && System.currentTimeMillis() - this.currentTime > this.second;
    }

    public String getComment() {
        return this.comment;
    }

    public int getMinute() {
        return (int)(this.second / 60000L);
    }

    public boolean isAutoExit() {
        return this.autoExit;
    }

    public static enum State {
        normalization,
        shutdown;

    }
}

