/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.aspect;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.aspect.event.MethodInvokeEvent;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.SerializableUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.After;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class AspectAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log logger = CtpLogFactory.getLog(AspectAnnotationAware.class);
    private static final String NOTIFY_ACCEPT_METHOD_INVOKES = "notify_accept_method_invokes";
    static Map<String, Collection<ExecuteUnit>> cache = new ConcurrentHashMap<String, Collection<ExecuteUnit>>();
    static Map<String, Collection<ExecuteUnit>> remoteAppectInvokerMap = new ConcurrentHashMap<String, Collection<ExecuteUnit>>();
    static final Set<String> needPubMethodInvokes = new HashSet<String>();
    static Set<String> methods = Collections.newSetFromMap(new ConcurrentHashMap());
    static Set<String> needParameterSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private AnnotationFactory annotationFactory;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    public static Map getAllListener(Class clazz) {
        if (After.class.equals((Object)clazz)) {
            return new HashMap<String, Collection<ExecuteUnit>>(cache);
        }
        throw new UnsupportedOperationException("\u76ee\u524d\u4ec5\u63d0\u4f9b\u4e86After\u652f\u6301");
    }

    private void cache(MethodAnnotation annotation) {
        Object bean = AppContext.getBean(annotation.getBeanName());
        After af = (After)annotation.getAnnotation();
        String[] value = af.value();
        ExecuteUnit unit = new ExecuteUnit(bean, annotation.getMethod());
        StringBuilder notFoundBeans = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            String v = value[i];
            this.processMethodInvokeStr(v, af.withParameters(), unit, notFoundBeans);
        }
        if (notFoundBeans.length() > 0) {
            logger.info((Object)("\u6ca1\u6709\u627e\u5230\u4ee5\u4e0b\u7684bean:" + notFoundBeans));
        }
    }

    private void processMethodInvokeStr(String v, boolean withParameters, ExecuteUnit unit, StringBuilder notFoundBeans) {
        if (Strings.isEmpty(v)) {
            return;
        }
        int index = v.lastIndexOf(".");
        if (index < 0) {
            logger.error((Object)("\u9519\u8bef\u7684After\u5f15\u7528:" + v));
            return;
        }
        String methodName = v.substring(index + 1);
        String beanName = v.substring(0, index);
        if (beanName.indexOf(".") < 0 || beanName.indexOf("/") > -1) {
            try {
                Object b = AppContext.getBean(beanName);
                if (b == null) {
                    notFoundBeans.append(beanName).append(" ");
                    this.addRemoteMethodInvoke(AspectAnnotationAware.getKey(beanName, methodName), unit);
                    return;
                }
                beanName = AopProxyUtils.ultimateTargetClass((Object)b).getCanonicalName();
            }
            catch (Throwable e) {
                logger.error((Object)("\u83b7\u53d6Bean\u51fa\u9519:" + beanName + " " + e.getLocalizedMessage()));
                return;
            }
        }
        String key = AspectAnnotationAware.getKey(beanName, methodName);
        try {
            Class.forName(beanName);
        }
        catch (ClassNotFoundException e) {
            this.addRemoteMethodInvoke(key, unit);
        }
        Collection<ExecuteUnit> collection = cache.get(key);
        if (collection == null) {
            collection = new CopyOnWriteArrayList<ExecuteUnit>();
        }
        collection.add(unit);
        cache.put(key, collection);
        methods.add(methodName);
        if (withParameters) {
            needParameterSet.add(key);
        }
    }

    private void addRemoteMethodInvoke(String key, ExecuteUnit unit) {
        if (SystemEnvironment.isDistributedMode()) {
            Collection<ExecuteUnit> invokers = remoteAppectInvokerMap.get(key);
            if (invokers == null) {
                invokers = new CopyOnWriteArrayList<ExecuteUnit>();
                remoteAppectInvokerMap.put(key, invokers);
            }
            invokers.add(unit);
        }
    }

    @Override
    public void initialize() {
        Set<MethodAnnotation> methodAnnotation = this.annotationFactory.getAnnotationOfMethod(After.class);
        if (methodAnnotation != null) {
            for (MethodAnnotation annotation : methodAnnotation) {
                try {
                    this.cache(annotation);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (SystemEnvironment.isDistributedMode()) {
                this.pubAndSubAspectInvokes();
            }
        }
        logger.info((Object)("\u521d\u59cb\u5316AspectAnnotation: " + cache.size()));
    }

    private void pubAndSubAspectInvokes() {
        if (remoteAppectInvokerMap.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String methodInvokeInfo : remoteAppectInvokerMap.keySet()) {
                stringBuffer.append(",");
                stringBuffer.append(methodInvokeInfo);
            }
            this.reportMethodInvokeInfos(stringBuffer.substring(1));
            RedisHandler.pubEvent(NOTIFY_ACCEPT_METHOD_INVOKES, (Serializable)SerializableUtil.fstSerialize(SystemEnvironment.getAppId()));
        }
        this.scanAndStoreAllMethodInvoks();
        RedisHandler.subEvent(new MessageListener(){

            public void onMessage(Message message, byte[] pattern) {
                String sourceAppId = SerializableUtil.fstSerializeToString(message.getBody());
                if (SystemEnvironment.getAppId().equals(sourceAppId)) {
                    return;
                }
                String methodInvokeStr = SerializableUtil.fstSerializeToString(RedisHandler.getConfigRedisTemplate().opsForValue().get((Object)("Platform:MethodInvoke:" + sourceAppId)));
                AspectAnnotationAware.storeLocalMethodInfo(methodInvokeStr);
            }
        }, NOTIFY_ACCEPT_METHOD_INVOKES, false);
    }

    private void scanAndStoreAllMethodInvoks() {
        Set methodInvokeKeys = RedisHandler.getConfigRedisTemplate().keys((Object)"Platform:MethodInvoke:*");
        for (String methodInvokeKey : methodInvokeKeys) {
            if (methodInvokeKey.equals("Platform:MethodInvoke:" + SystemEnvironment.getAppId())) continue;
            String methodInvokeStr = SerializableUtil.fstSerializeToString(RedisHandler.getConfigRedisTemplate().opsForValue().get((Object)methodInvokeKey));
            AspectAnnotationAware.storeLocalMethodInfo(methodInvokeStr);
        }
    }

    private static void storeLocalMethodInfo(String methodInvokeStr) {
        if (methodInvokeStr == null) {
            return;
        }
        for (String methodInvokeInfo : methodInvokeStr.split(",")) {
            int index = methodInvokeInfo.lastIndexOf(".");
            if (index < 0) {
                return;
            }
            String methodName = methodInvokeInfo.substring(index + 1);
            String beanName = methodInvokeInfo.substring(0, index);
            if (beanName.indexOf(".") < 0 || beanName.indexOf("/") > -1) {
                try {
                    Object b = AppContext.getBean(beanName);
                    if (b == null) continue;
                    beanName = AopProxyUtils.ultimateTargetClass((Object)b).getCanonicalName();
                }
                catch (Throwable e) {
                    logger.error((Object)("\u8fdc\u7a0b\u83b7\u53d6Bean\u51fa\u9519:" + beanName + " " + e.getLocalizedMessage()));
                    continue;
                }
            }
            try {
                Class.forName(beanName);
                needPubMethodInvokes.add(beanName + "." + methodName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void reportMethodInvokeInfos(String methodInvokeInfos) {
        RedisHandler.getConfigRedisTemplate().opsForValue().set((Object)("Platform:MethodInvoke:" + SystemEnvironment.getAppId()), (Object)SerializableUtil.fstSerialize(methodInvokeInfos));
    }

    @ListenEvent(event=MethodInvokeEvent.class)
    public void listenMethodInvokeEvent(MethodInvokeEvent methodInvokeEvent) {
        if (!SystemEnvironment.isDistributedMode() || SystemEnvironment.getAppId().equals(methodInvokeEvent.getAppId())) {
            return;
        }
        Collection<ExecuteUnit> collection = remoteAppectInvokerMap.get(methodInvokeEvent.getMethodInfo());
        if (collection != null) {
            for (ExecuteUnit unit : collection) {
                try {
                    unit.execute();
                }
                catch (Exception e) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSortOrder() {
        return -4;
    }

    private static String getKey(String className, String methodName) {
        return className + "." + methodName;
    }

    class ExecuteUnit {
        private Method method;
        private Object bean;

        public ExecuteUnit(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
        }

        public void execute() throws Exception {
            if (AopUtils.isJdkDynamicProxy((Object)this.bean)) {
                this.method.invoke(((Advised)this.bean).getTargetSource().getTarget(), new Object[0]);
            } else {
                this.method.invoke(this.bean, new Object[0]);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(AopUtils.getTargetClass((Object)this.bean).getCanonicalName()).append(".").append(this.method.getName());
            return sb.toString();
        }
    }
}

