/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserPasswordManager {
    private static final int UNKOWN = 5;
    private static Log LOG = LogFactory.getLog(UserPasswordManager.class);
    private final CacheAccessable factory = CacheFactory.getInstance(UserPasswordManager.class);
    private final CacheMap<Long, Integer> strengthMap = this.factory.createMap("passwordStrength");
    private static final UserPasswordManager INSTANCE = new UserPasswordManager();

    private UserPasswordManager() {
    }

    public static final UserPasswordManager getInstance() {
        return INSTANCE;
    }

    public int getLoginPasswordStrength(Long memberId) {
        Integer value = this.strengthMap.get(memberId);
        return value == null ? 5 : value;
    }

    public void setLoginPasswordStrength(Long memberId, int strength) {
        this.strengthMap.put(memberId, strength);
    }

    public int checkStrength(String password) {
        try {
            return (int)Double.parseDouble(StringUtil.getPasswdStrong(password));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return 5;
        }
    }
}

