/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.common.cache.AbstractCacheFactory;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.GenericTimeRing;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.TimeRing;
import com.seeyon.ctp.common.cache.geode.GeodeCacheAccessable;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class CacheFactory
extends AbstractCacheFactory {
    private static Log log = CtpLogFactory.getLog(CacheFactory.class);
    private static boolean skipFillData = false;
    private static Map<String, CacheAccessable> instanceHolder = new ConcurrentHashMap<String, CacheAccessable>();
    private static byte[] lock = new byte[0];
    private static boolean enableCluster = false;
    private TimeRing<Serializable> instance = new GenericTimeRing();

    protected CacheFactory(String group) {
        super(group);
        this.pool = new AbstractCacheFactory.CachePool(){
            private Map<String, GroupCacheable> caches = new ConcurrentHashMap<String, GroupCacheable>();

            @Override
            protected GroupCacheable get(String key) {
                return this.caches.get(key);
            }

            @Override
            protected boolean contains(String key) {
                return this.caches.containsKey(key);
            }

            @Override
            protected void put(String key, GroupCacheable cache) {
                this.caches.put(key, cache);
            }

            @Override
            public String[] getCacheNames(String group) {
                ArrayList<String> l = new ArrayList<String>();
                for (String key : this.caches.keySet()) {
                    String[] arr = this.parseKey(key);
                    if (arr == null || arr.length != 2 || !group.equals(arr[0])) continue;
                    l.add(arr[1]);
                }
                Object[] result = new String[l.size()];
                result = l.toArray(result);
                Arrays.sort(result);
                return result;
            }

            @Override
            public void clear() {
                this.caches.clear();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CacheAccessable getInstance(String group) {
        byte[] byArray = lock;
        synchronized (lock) {
            if (instanceHolder.get(group) == null) {
                if (RedisHandler.isRedisEnabled() || !ClusterConfigBean.getInstance().isGeodeEnabled()) {
                    instanceHolder.put(group, new CacheFactory(group));
                } else {
                    if (Strings.isEmpty(group)) {
                        group = "EMPTY";
                    }
                    GeodeCacheAccessable groupCache = GeodeService.getGroupCacheInstance(group);
                    instanceHolder.put(group, groupCache);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instanceHolder.get(group);
        }
    }

    public static final CacheAccessable getInstance(Class group) {
        return CacheFactory.getInstance(group.getCanonicalName());
    }

    public static void setClusterEnabled(boolean b) {
        enableCluster = b;
    }

    public static boolean isClusterEnabled() {
        return enableCluster;
    }

    public static String[] getGroups() {
        Object[] result = new String[instanceHolder.size()];
        result = instanceHolder.keySet().toArray(result);
        Arrays.sort(result);
        return result;
    }

    @Override
    public String[] getCacheNames() {
        return this.pool.getCacheNames(this.group);
    }

    @Override
    public <E extends Serializable> TimeRing<E> createTimeRing(String cacheName) {
        return this.instance;
    }

    public static void resetAllStatistics() {
        String[] groupNames;
        for (String g : groupNames = CacheFactory.getGroups()) {
            String[] cacheNames;
            CacheAccessable factory = CacheFactory.getInstance(g);
            for (String cacheName : cacheNames = factory.getCacheNames()) {
                GroupCacheable cache = factory.lookup(cacheName);
                cache.getStatistics().resetStatistics();
            }
        }
    }

    public static boolean isSkipFillData() {
        if (skipFillData) {
            skipFillData = !GeodeService.isAlone();
        }
        return skipFillData;
    }

    public static void setSkipFillData(boolean skipFillData) {
        CacheFactory.skipFillData = skipFillData;
    }

    public static void enableCacheNotify() {
        if (ClusterConfigBean.getInstance().isGeodeEnabled()) {
            GeodeService.enableCacheNotify();
        }
        RedisHandler.activePublishCacheChange();
    }
}

