/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.AbstractGroupCache;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;

class GenericCacheSet<E extends Serializable>
extends AbstractGroupCache
implements CacheSet<E> {
    private static Log log = CtpLogFactory.getLog(GenericCacheSet.class);
    private Set<E> set = new CopyOnWriteArraySet();

    public GenericCacheSet(String group, String name, CacheConfiguration config) {
        super(group, name, config);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<E> iterator() {
        this.statistics.read();
        return this.set.iterator();
    }

    @Override
    public boolean contains(E o) {
        this.statistics.read();
        return this.set.contains(o);
    }

    @Override
    public Set<E> toSet() {
        this.statistics.read();
        return new HashSet<E>(this.set);
    }

    @Override
    public void clear() {
        this.set.clear();
        this.statistics.clear();
        this.sendNotification(null, null, CacheNotification.Action.Clear);
    }

    @Override
    public boolean add(E o) {
        boolean result = this.set.add(o);
        if (result) {
            this.statistics.write();
            this.sendNotification(null, (Serializable)o, CacheNotification.Action.Add);
        }
        return result;
    }

    @Override
    public boolean remove(E o) {
        boolean result = this.set.remove(o);
        if (result) {
            this.statistics.delete();
            this.sendNotification(null, (Serializable)o, CacheNotification.Action.Remove);
        }
        return result;
    }

    @Override
    public void notifyUpdate(E e) {
        if (this.contains(e)) {
            this.sendNotification(null, (Serializable)e, CacheNotification.Action.Add);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.set.addAll(c);
        if (result) {
            this.statistics.write();
            this.sendNotification(null, new HashSet<E>(c), CacheNotification.Action.AddAll);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<? extends E> c) {
        boolean result = this.set.removeAll(c);
        if (result) {
            this.statistics.clear();
            this.sendNotification(null, new HashSet<E>(c), CacheNotification.Action.RemoveAll);
        }
        return result;
    }

    @Override
    public void replaceAll(Collection<? extends E> c) {
        this.set.clear();
        this.statistics.clear();
        this.set.addAll(c);
        this.statistics.write();
        this.sendNotification(null, new HashSet<E>(c), CacheNotification.Action.ReplaceAll);
    }
}

