/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.TimeRing;
import com.seeyon.ctp.util.LRUMap;
import java.io.Serializable;

public class GenericTimeRing<E extends Serializable>
implements TimeRing {
    private static LRUMap<Serializable, Long> map = new LRUMap(10000);

    public boolean isExist(Serializable e) {
        Long expired = map.get(e);
        if (expired == null) {
            return false;
        }
        if (expired < System.currentTimeMillis()) {
            map.remove(e);
            return false;
        }
        return true;
    }

    public boolean add(Serializable e, long expiration) {
        map.put(e, System.currentTimeMillis() + expiration);
        return true;
    }

    @Override
    public void clear() {
        map.clear();
    }

    public static void clearAll() {
        map.clear();
    }
}

