/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.etag;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.etag.ETagCacheManager;
import com.seeyon.ctp.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ETagCacheManagerImpl
implements ETagCacheManager {
    private static Log log = LogFactory.getLog(ETagCacheManagerImpl.class);
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(ETagCacheManagerImpl.class);
    private CacheMap<String, Long> eTagModifyCache = cacheFactory.createMap("eTagModifyCache");

    @Override
    public Long getETagDate(String category, String key) {
        if (Strings.isBlank(category) || Strings.isBlank(key)) {
            return null;
        }
        String keys = category + "|" + key;
        Long date = this.eTagModifyCache.get(keys);
        if (date == null) {
            date = System.currentTimeMillis();
            this.eTagModifyCache.put(keys, date);
        }
        return date;
    }

    @Override
    public void updateETagDate(String category, String key) {
        if (Strings.isBlank(category) || Strings.isBlank(key)) {
            return;
        }
        String keys = category + "|" + key;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u66f4\u65b0ETag:" + keys));
        }
        this.eTagModifyCache.put(keys, System.currentTimeMillis());
    }

    @Override
    public void clearCategoryETagDate(String category) {
        this.eTagModifyCache.remove(category);
    }
}

