/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.geode.AbstractGeodeCache;
import com.seeyon.ctp.common.cache.geode.GeodeCacheMap;
import java.io.Serializable;

public class GeodeCacheObject<T extends Serializable>
extends AbstractGeodeCache
implements CacheObject<T> {
    private GeodeCacheMap region;
    private String group;
    private String name;

    public GeodeCacheObject(GeodeCacheMap region, String group, String name) {
        this.region = region;
        this.group = group;
        this.name = name;
    }

    public void setRegion(GeodeCacheMap region) {
        this.region = region;
    }

    @Override
    public void set(T o) {
        this.region.put(this.name, o);
        this.statistics.write();
    }

    @Override
    public T get() {
        this.statistics.read();
        Object result = this.region.get(this.name);
        if (result == null) {
            this.statistics.misses();
        }
        return (T)result;
    }

    @Override
    public void notifyUpdate() {
        this.region.put(this.name, this.region.get(this.name));
        this.statistics.write();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.region.get(this.name) == null;
    }

    @Override
    public void clear() {
        this.region.remove(this.name);
        this.statistics.clear();
    }
}

