/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.geode.AbstractGeodeCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.cache.Region;

public class GeodeCacheSet<T extends Serializable>
extends AbstractGeodeCache
implements CacheSet<T> {
    private Region region;
    private static final Serializable PRESENT = new Integer(0);

    public GeodeCacheSet(Region region) {
        this.region = region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public boolean contains(T o) {
        if (o == null) {
            return false;
        }
        this.statistics.read();
        return this.region.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        this.statistics.read();
        return this.region.keySet().iterator();
    }

    @Override
    public Set<T> toSet() {
        this.statistics.read();
        return this.region.keySet();
    }

    @Override
    public boolean add(T o) {
        this.statistics.write();
        return this.region.put(o, (Object)PRESENT) != null;
    }

    @Override
    public boolean remove(T o) {
        this.statistics.delete();
        return this.region.remove(o) != null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.statistics.write();
        boolean modified = false;
        for (Serializable e : c) {
            if (!this.add((T)e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void replaceAll(Collection<? extends T> set) {
        this.statistics.clear();
        this.region.clear();
        for (Serializable e : set) {
            this.add((T)e);
        }
    }

    @Override
    public boolean removeAll(Collection<? extends T> c) {
        boolean modified = false;
        for (Serializable e : c) {
            if (!this.remove((T)e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void notifyUpdate(T k) {
        if (this.contains(k)) {
            this.add(k);
        }
    }

    @Override
    public String getGroup() {
        return this.region.getParentRegion().getName();
    }

    @Override
    public String getName() {
        return this.region.getName();
    }

    @Override
    public int size() {
        return this.region.size();
    }

    @Override
    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    @Override
    public void clear() {
        this.statistics.clear();
        this.region.clear();
    }
}

