/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.seeyon.ctp.cluster.NotificationAnnotationAware;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotification;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.cluster.notification.PendingNotificationQueue;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.geode.GeodeCacheAccessable;
import com.seeyon.ctp.common.cache.geode.LRUCacheMap;
import com.seeyon.ctp.common.cache.geode.LRUCacheMapChange;
import com.seeyon.ctp.common.cache.geode.LinkedCacheMap;
import com.seeyon.ctp.common.cache.geode.LinkedCacheMapChange;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;

public class GeodeEventHandler<K, V>
extends CacheListenerAdapter<K, V> {
    private static Log logger = CtpLogFactory.getLog(GeodeEventHandler.class);
    public static final String EVENT_REGION = "GEODE_EVENT";
    public static final String CACHE_NOTIFY_REGION = "CACHE_NOTIFICATION";
    public static final String LINKED_CACHE_MAP_REGION = "LINKED_CACHE_MAP_REGION";
    public static final String LRU_CACHE_MAP_REGION = "LRU_CACHE_MAP_REGION";
    private static final Map<NotificationType, NotificationListener> handlersMap = new LinkedHashMap<NotificationType, NotificationListener>();
    private static final ThreadLocal<Boolean> stopDispatch = new ThreadLocal();
    private static final ExecutorService executors = Executors.newFixedThreadPool(20, (ThreadFactory)new NamedThreadFactory("Geode-Event-Process"));

    public void afterCreate(EntryEvent<K, V> event) {
        this.handleEvent(event);
    }

    public void afterUpdate(EntryEvent<K, V> event) {
        this.handleEvent(event);
    }

    public void afterDestroy(EntryEvent<K, V> event) {
    }

    private void handleEvent(final EntryEvent<K, V> event) {
        executors.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    stopDispatch.set(true);
                    if (!event.isOriginRemote()) {
                        return;
                    }
                    if (event.getRegion().getName().equals(GeodeEventHandler.EVENT_REGION)) {
                        GeodeEventHandler.this.handleNotification(event.getKey(), event.getNewValue());
                        return;
                    }
                    if (event.getRegion().getName().equals(GeodeEventHandler.LINKED_CACHE_MAP_REGION)) {
                        GeodeEventHandler.this.handleLinkedCacheMapChange(event.getKey(), event.getNewValue());
                        return;
                    }
                    if (event.getRegion().getName().equals(GeodeEventHandler.LRU_CACHE_MAP_REGION)) {
                        GeodeEventHandler.this.handleLRUCacheMapChange(event.getKey(), event.getNewValue());
                        return;
                    }
                    if (event.getRegion().getName().equals(GeodeEventHandler.CACHE_NOTIFY_REGION)) {
                        GeodeEventHandler.this.handleCacheMapChange(event.getKey(), event.getNewValue());
                        return;
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)t.getLocalizedMessage(), t);
                }
                finally {
                    stopDispatch.remove();
                }
            }
        });
    }

    public void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        handlersMap.put(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNotification(K k, V v) {
        NotificationListener handler = handlersMap.get(k);
        Notification notification = (Notification)v;
        if (handler != null) {
            try {
                NotificationManager.getInstance().enableSend(false);
                handler.handle(notification.getContent());
            }
            catch (Exception e) {
                logger.error((Object)"\u5904\u7406\u96c6\u7fa4\u6d88\u606f\u51fa\u9519", (Throwable)e);
            }
            finally {
                NotificationManager.getInstance().enableSend(true);
            }
        } else if (NotificationAnnotationAware.isRegisterFinished()) {
            logger.warn((Object)("\u672a\u6ce8\u518c\u96c6\u7fa4\u4e8b\u4ef6\u5904\u7406\u5668\uff0cNotificationType\uff1a" + ((NotificationType)((Object)k)).name()));
        } else {
            CNotification n = new CNotification();
            n.setType(notification.getType().ordinal());
            n.setContent(notification);
            PendingNotificationQueue.getInstance().offer(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleLinkedCacheMapChange(K key, V newValue) {
        LinkedCacheMapChange mapChange = (LinkedCacheMapChange)newValue;
        LinkedCacheMap<Serializable, Serializable> cacheMap = ((GeodeCacheAccessable)CacheFactory.getInstance((String)key)).getLinkdedMap(mapChange.getCacheName());
        if (cacheMap == null) {
            return;
        }
        try {
            cacheMap.setNeedNotify(false);
            switch (mapChange.getOperation()) {
                case Put: {
                    cacheMap.put(mapChange.getKey(), (Serializable)mapChange.getContent());
                    return;
                }
                case PutAll: {
                    cacheMap.putAll((Map)mapChange.getContent());
                    return;
                }
                case ReplaceAll: {
                    cacheMap.replaceAll((Map)mapChange.getContent());
                    return;
                }
                case Remove: {
                    cacheMap.remove(mapChange.getKey());
                    return;
                }
                case RemoveAll: {
                    cacheMap.removeAll((Collection)mapChange.getContent());
                    return;
                }
                case Clear: {
                    cacheMap.clear();
                    return;
                }
            }
            return;
        }
        finally {
            cacheMap.setNeedNotify(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleLRUCacheMapChange(K key, V newValue) {
        LRUCacheMapChange mapChange = (LRUCacheMapChange)newValue;
        LRUCacheMap<Serializable, Serializable> cacheMap = ((GeodeCacheAccessable)CacheFactory.getInstance((String)key)).getLRUMap(mapChange.getCacheName());
        if (cacheMap == null) {
            return;
        }
        try {
            cacheMap.setNeedNotify(false);
            switch (mapChange.getOperation()) {
                case Put: {
                    cacheMap.put(mapChange.getKey(), (Serializable)mapChange.getContent());
                    return;
                }
                case PutAll: {
                    cacheMap.putAll((Map)mapChange.getContent());
                    return;
                }
                case ReplaceAll: {
                    cacheMap.replaceAll((Map)mapChange.getContent());
                    return;
                }
                case Remove: {
                    cacheMap.remove(mapChange.getKey());
                    return;
                }
                case RemoveAll: {
                    cacheMap.removeAll((Collection)mapChange.getContent());
                    return;
                }
                case Clear: {
                    cacheMap.clear();
                    return;
                }
            }
            return;
        }
        finally {
            cacheMap.setNeedNotify(true);
        }
    }

    private void handleCacheMapChange(K key, V newValue) {
        CacheMapChange mapChange = (CacheMapChange)newValue;
        CacheMap cacheMap = CacheFactory.getInstance((String)key).getMap(mapChange.getCacheName());
        if (cacheMap == null) {
            return;
        }
        if (CacheNotification.Action.Reload.equals((Object)mapChange.getOperation())) {
            Serializable objKey = mapChange.getKey();
            if (objKey == null) {
                cacheMap.reload();
            } else {
                cacheMap.reload(objKey);
            }
        } else {
            Object data = cacheMap.get(mapChange.getKey());
            if (data != null && data instanceof Map) {
                Map dataMap = (Map)data;
                switch (mapChange.getOperation()) {
                    case Put: {
                        dataMap.put(mapChange.getUpdateKey(), mapChange.getContent());
                        break;
                    }
                    case PutAll: {
                        dataMap.putAll((Map)mapChange.getContent());
                        break;
                    }
                    case ReplaceAll: {
                        dataMap.putAll((Map)mapChange.getContent());
                        break;
                    }
                    case Remove: {
                        dataMap.remove(mapChange.getUpdateKey());
                        break;
                    }
                    case Clear: {
                        dataMap.clear();
                    }
                }
            }
        }
    }

    public static boolean canDispatch() {
        return stopDispatch.get() == null || stopDispatch.get() == false;
    }
}

