/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.geode;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationTransactionManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.geode.GeodeService;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.geode.cache.Region;

public class GeodeNotificationManager
extends NotificationManager {
    private static final Log logger = CtpLogFactory.getLog(GeodeNotificationManager.class);
    private Region eventRegion;
    private ThreadLocal<Boolean> canSend = new ThreadLocal();

    public GeodeNotificationManager(Region eventRegion) {
        this.eventRegion = eventRegion;
        this.initNotificationHandlers();
    }

    private void initNotificationHandlers() {
        this.register(NotificationType.BatchNotification, new NotificationListener(){

            @Override
            public void handle(Object o) {
                if (o == null) {
                    return;
                }
                if (o instanceof List) {
                    List nl = (List)o;
                    for (Notification n : nl) {
                        GeodeNotificationManager.this.handleNotify(n);
                    }
                } else {
                    logger.warn((Object)("\u4e0d\u53ef\u8bc6\u522b\u7684\u590d\u5408\u901a\u77e5\u6570\u636e\u3002\u671f\u5f85\uff1aBatchNotification\uff1b\u5b9e\u9645\uff1a" + o));
                }
            }

            @Override
            public NotificationType getType() {
                return NotificationType.BatchNotification;
            }
        });
    }

    private void handleNotify(Notification n) {
        GeodeService.handleNotify(n);
    }

    public void setEventRegion(Region eventRegion) {
        this.eventRegion = eventRegion;
    }

    @Override
    public void send(NotificationType type, Object content) {
        this.send(type, content, false);
    }

    @Override
    public void send(NotificationType type, Object content, boolean force) {
        Notification notification = new Notification();
        notification.setType(type);
        notification.setContent(content);
        this.send(notification, force);
    }

    @Override
    public void send(Notification notification) {
        this.send(notification, false);
    }

    @Override
    public void send(Notification notification, boolean force) {
        if (!this.isSendEnabled()) {
            return;
        }
        NotificationTransactionManager transManager = NotificationTransactionManager.getInstance();
        if (transManager.hasTransaction() && !NotificationType.ProductInfo.equals((Object)notification.getType())) {
            logger.debug((Object)("add notification to batch:" + notification.getType().name()));
            transManager.addNotification(notification.getType(), notification.getContent());
            return;
        }
        this.eventRegion.put((Object)notification.getType(), (Object)notification);
    }

    @Override
    public void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        GeodeService.register(type, listener);
    }

    @Override
    public void register(NotificationListener listener) {
        this.register(listener.getType(), listener);
    }

    @Override
    public String getLocalAddress() {
        return ClusterConfigBean.getInstance().getLocalhost();
    }

    @Override
    public void enableSend(boolean enable) {
        this.canSend.set(enable);
    }

    @Override
    public boolean isSendEnabled() {
        return this.canSend.get() == null ? true : this.canSend.get();
    }
}

