/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.cluster.NotificationAnnotationAware;
import com.seeyon.ctp.cluster.adapter.jgroups.CNotification;
import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.cluster.notification.PendingNotificationQueue;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class RedisNotificationListener {
    private static Log logger = CtpLogFactory.getLog(RedisNotificationListener.class);
    private static final Map<NotificationType, NotificationListener> handlersMap = new LinkedHashMap<NotificationType, NotificationListener>();

    public void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        handlersMap.put(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNotify(NotificationType type, Notification notification) {
        NotificationListener handler = handlersMap.get((Object)type);
        if (handler != null) {
            try {
                NotificationManager.getInstance().enableSend(false);
                handler.handle(notification.getContent());
            }
            catch (Exception e) {
                logger.error((Object)"\u5904\u7406\u96c6\u7fa4\u6d88\u606f\u51fa\u9519", (Throwable)e);
            }
            finally {
                NotificationManager.getInstance().enableSend(true);
            }
        } else if (NotificationAnnotationAware.isRegisterFinished()) {
            logger.warn((Object)("\u672a\u6ce8\u518c\u96c6\u7fa4\u4e8b\u4ef6\u5904\u7406\u5668\uff0cNotificationType\uff1a" + type.name()));
        } else {
            CNotification n = new CNotification();
            n.setType(notification.getType().ordinal());
            n.setContent(notification);
            PendingNotificationQueue.getInstance().offer(n);
        }
    }
}

