/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cglib;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.CglibBeanCopier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CglibCopier {
    private static final Log log = LogFactory.getLog(CglibCopier.class);
    private static Map<String, CglibBeanCopier> copiers = new ConcurrentHashMap<String, CglibBeanCopier>();

    private static CglibBeanCopier getCopier(Class source, Class target) {
        String key = source.getName() + "_" + target.getName();
        CglibBeanCopier cbc = copiers.get(key);
        if (cbc != null) {
            return cbc;
        }
        try {
            CglibBeanCopier c = CglibBeanCopier.create(source, target, false);
            copiers.put(key, c);
            return c;
        }
        catch (Exception e) {
            log.error((Object)"Create BeanCopier Error!", (Throwable)e);
            return null;
        }
    }

    public static void copy(Object source, Object target) {
        CglibBeanCopier c = CglibCopier.getCopier(source.getClass(), target.getClass());
        if (c != null) {
            c.copy(source, target, null);
        } else {
            log.warn((Object)"cann't get Copier");
        }
    }
}

