/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.config;

import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.config.ConfigItem;
import com.seeyon.ctp.util.annotation.HandleNotification;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;

public class SystemConfig {
    private static final Log log = CtpLogFactory.getLog(SystemConfig.class);
    public static final String SWITCH = "system_switch";
    public static final String DATA_I18N_ENABLE = "data_i18n_enable";
    public static final String DATETIME_FORMAT_ENABLE = "datetime_format_enable";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    private ConfigManager configManager;
    private CacheMap<String, String> systemSwitch;
    private Map<String, String> DefaultValue;

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setDefaultValue(Map<String, String> dv) {
        this.DefaultValue = dv;
    }

    public void init() {
        String name;
        CacheAccessable c = CacheFactory.getInstance(SystemConfig.class);
        this.systemSwitch = c.createMap("systemOpen");
        List<ConfigItem> configs = this.configManager.listAllConfigByCategory(SWITCH, 1L);
        for (ConfigItem configItem : configs) {
            name = configItem.getConfigItem();
            this.systemSwitch.put(name, configItem.getConfigValue());
        }
        for (Map.Entry<String, String> d : this.DefaultValue.entrySet()) {
            name = d.getKey();
            String value = d.getValue();
            if (this.systemSwitch.contains(name)) continue;
            this.configManager.addConfigItem(SWITCH, name, value, 1L);
            this.systemSwitch.put(name, value);
        }
        log.info((Object)("\u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u5f00\u5173: " + this.systemSwitch.size()));
    }

    public void update(String name, String value) {
        if (this.systemSwitch.get(name) != null && this.systemSwitch.get(name).equals(value)) {
            return;
        }
        ConfigItem config = this.configManager.getConfigItem(SWITCH, name, 1L);
        if (config == null) {
            this.configManager.addConfigItem(SWITCH, name, value, 1L);
        } else {
            config.setConfigValue(value);
            this.configManager.updateConfigItem(config);
        }
        this.systemSwitch.put(name, value);
    }

    public String getDefaultValue(String name) {
        return this.DefaultValue.get(name);
    }

    public Set<String> names() {
        return new HashSet<String>(this.systemSwitch.keySet());
    }

    public Map<String, String> getAll() {
        return this.systemSwitch.toMap();
    }

    public String get(String name) {
        if (!this.systemSwitch.contains(name)) {
            log.warn((Object)("\u5f00\u5173\u914d\u7f6e[" + name + "]\u4e0d\u5b58\u5728"));
        }
        return this.systemSwitch.get(name);
    }

    @HandleNotification(type=NotificationType.SysPropertiesUpdate)
    public void updateSysProperties(Object o) {
        if (o instanceof Properties) {
            try {
                Properties props = (Properties)o;
                for (String key : props.stringPropertyNames()) {
                    SystemProperties.getInstance().put(key, props.getProperty(key));
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }
}

